/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.inventory.updater;

import java.util.Arrays;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.InventoryContentPacket;
import org.cloudburstmc.protocol.bedrock.packet.InventorySlotPacket;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.updater.InventoryUpdater;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.InventoryTranslator;

public class CrafterInventoryUpdater
extends InventoryUpdater {
    public static final CrafterInventoryUpdater INSTANCE = new CrafterInventoryUpdater();

    @Override
    public void updateInventory(InventoryTranslator translator, GeyserSession session, Inventory inventory) {
        int i;
        ItemData[] bedrockItems = new ItemData[9];
        for (i = 0; i < bedrockItems.length; ++i) {
            bedrockItems[translator.javaSlotToBedrock((int)i)] = inventory.getItem(i).getItemData(session);
        }
        InventoryContentPacket contentPacket = new InventoryContentPacket();
        contentPacket.setContainerId(inventory.getBedrockId());
        contentPacket.setContents(Arrays.asList(bedrockItems));
        session.sendUpstreamPacket((BedrockPacket)contentPacket);
        bedrockItems = new ItemData[36];
        for (i = 0; i < 36; ++i) {
            int offset = i < 9 ? 27 : -9;
            bedrockItems[i] = inventory.getItem(9 + i + offset).getItemData(session);
        }
        contentPacket = new InventoryContentPacket();
        contentPacket.setContainerId(0);
        contentPacket.setContents(Arrays.asList(bedrockItems));
        session.sendUpstreamPacket((BedrockPacket)contentPacket);
        this.updateSlot(translator, session, inventory, 45);
    }

    @Override
    public boolean updateSlot(InventoryTranslator translator, GeyserSession session, Inventory inventory, int javaSlot) {
        int containerId = javaSlot < 9 || javaSlot == 45 ? inventory.getBedrockId() : 0;
        InventorySlotPacket packet = new InventorySlotPacket();
        packet.setContainerId(containerId);
        packet.setSlot(translator.javaSlotToBedrock(javaSlot));
        packet.setItem(inventory.getItem(javaSlot).getItemData(session));
        session.sendUpstreamPacket((BedrockPacket)packet);
        return true;
    }
}

