/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util;

import org.cloudburstmc.math.vector.Vector3i;
import org.geysermc.geyser.entity.attribute.GeyserAttributeType;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.EntityEffectCache;
import org.geysermc.geyser.translator.collision.BlockCollision;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.ToolData;

public final class BlockUtils {
    public static float getBlockMiningProgressPerTick(GeyserSession session, Block block, GeyserItemStack itemInHand) {
        float destroySpeed = block.destroyTime();
        if (destroySpeed == -1.0f) {
            return 0.0f;
        }
        int speedMultiplier = BlockUtils.hasCorrectTool(session, block, itemInHand) ? 30 : 100;
        return BlockUtils.getPlayerDestroySpeed(session, block, itemInHand) / destroySpeed / (float)speedMultiplier;
    }

    private static boolean hasCorrectTool(GeyserSession session, Block block, GeyserItemStack stack) {
        return !block.requiresCorrectToolForDrops() || BlockUtils.isCorrectItemForDrops(session, block, stack);
    }

    private static boolean isCorrectItemForDrops(GeyserSession session, Block block, GeyserItemStack stack) {
        ToolData tool = (ToolData)stack.getComponent(DataComponentTypes.TOOL);
        if (tool == null) {
            return false;
        }
        for (ToolData.Rule rule : tool.getRules()) {
            if (rule.getCorrectForDrops() == null || !session.getTagCache().isBlock(rule.getBlocks(), block)) continue;
            return rule.getCorrectForDrops();
        }
        return false;
    }

    private static float getItemDestroySpeed(GeyserSession session, Block block, GeyserItemStack stack) {
        ToolData tool = (ToolData)stack.getComponent(DataComponentTypes.TOOL);
        if (tool == null) {
            return 1.0f;
        }
        for (ToolData.Rule rule : tool.getRules()) {
            if (rule.getSpeed() == null || !session.getTagCache().isBlock(rule.getBlocks(), block)) continue;
            return rule.getSpeed().floatValue();
        }
        return tool.getDefaultMiningSpeed();
    }

    private static float getPlayerDestroySpeed(GeyserSession session, Block block, GeyserItemStack itemInHand) {
        int miningSpeedMultiplier;
        float destroySpeed = BlockUtils.getItemDestroySpeed(session, block, itemInHand);
        EntityEffectCache effectCache = session.getEffectCache();
        if (destroySpeed > 1.0f) {
            destroySpeed += session.getPlayerEntity().attributeOrDefault(GeyserAttributeType.MINING_EFFICIENCY);
        }
        if ((miningSpeedMultiplier = BlockUtils.getMiningSpeedAmplification(effectCache)) > 0) {
            destroySpeed *= (float)miningSpeedMultiplier * 0.2f;
        }
        if (effectCache.getMiningFatigue() != 0) {
            float slowdown = switch (effectCache.getMiningFatigue()) {
                case 1 -> 0.3f;
                case 2 -> 0.09f;
                case 3 -> 0.0027f;
                default -> 8.1E-4f;
            };
            destroySpeed *= slowdown;
        }
        destroySpeed *= session.getPlayerEntity().attributeOrDefault(GeyserAttributeType.BLOCK_BREAK_SPEED);
        if (session.getCollisionManager().isWaterInEyes()) {
            destroySpeed *= session.getPlayerEntity().attributeOrDefault(GeyserAttributeType.SUBMERGED_MINING_SPEED);
        }
        if (!session.getPlayerEntity().isOnGround()) {
            destroySpeed /= 5.0f;
        }
        return destroySpeed;
    }

    private static int getMiningSpeedAmplification(EntityEffectCache cache) {
        return Math.max(cache.getHaste(), cache.getConduitPower());
    }

    public static double getSessionBreakTimeTicks(GeyserSession session, Block block) {
        return Math.ceil(1.0f / BlockUtils.getBlockMiningProgressPerTick(session, block, session.getPlayerInventory().getItemInHand()));
    }

    public static Vector3i getBlockPosition(Vector3i blockPos, int face) {
        return switch (face) {
            case 0 -> blockPos.sub(0, 1, 0);
            case 1 -> blockPos.add(0, 1, 0);
            case 2 -> blockPos.sub(0, 0, 1);
            case 3 -> blockPos.add(0, 0, 1);
            case 4 -> blockPos.sub(1, 0, 0);
            case 5 -> blockPos.add(1, 0, 0);
            default -> blockPos;
        };
    }

    public static String getCleanIdentifier(String fullJavaIdentifier) {
        int stateIndex = fullJavaIdentifier.indexOf(91);
        if (stateIndex == -1) {
            return fullJavaIdentifier;
        }
        return fullJavaIdentifier.substring(0, stateIndex);
    }

    public static BlockCollision getCollision(int blockId) {
        return BlockRegistries.COLLISIONS.get(blockId);
    }

    public static BlockCollision getCollisionAt(GeyserSession session, Vector3i blockPos) {
        return BlockUtils.getCollision(session.getGeyser().getWorldManager().getBlockAt(session, blockPos));
    }

    private BlockUtils() {
    }
}

