/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.math.immutable.vector;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.cloudburstmc.math.GenericMath;
import org.cloudburstmc.math.vector.Vector4f;

@ParametersAreNonnullByDefault
@Immutable
public class ImmutableVector4f
extends Vector4f {
    private static final long serialVersionUID = 1L;
    private final float x;
    private final float y;
    private final float z;
    private final float w;
    private volatile transient boolean hashed = false;
    private volatile transient int hashCode = 0;

    ImmutableVector4f(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    @Override
    public float getX() {
        return this.x;
    }

    @Override
    public float getY() {
        return this.y;
    }

    @Override
    public float getZ() {
        return this.z;
    }

    @Override
    public float getW() {
        return this.w;
    }

    @Override
    @Nonnull
    public Vector4f add(float x, float y, float z, float w) {
        return Vector4f.from(this.getX() + x, this.getY() + y, this.getZ() + z, this.getW() + w);
    }

    @Override
    @Nonnull
    public Vector4f sub(float x, float y, float z, float w) {
        return Vector4f.from(this.getX() - x, this.getY() - y, this.getZ() - z, this.getW() - w);
    }

    @Override
    @Nonnull
    public Vector4f mul(float x, float y, float z, float w) {
        return Vector4f.from(this.getX() * x, this.getY() * y, this.getZ() * z, this.getW() * w);
    }

    @Override
    @Nonnull
    public Vector4f div(float x, float y, float z, float w) {
        return Vector4f.from(this.getX() / x, this.getY() / y, this.getZ() / z, this.getW() / w);
    }

    @Override
    @Nonnull
    public Vector4f project(float x, float y, float z, float w) {
        float lengthSquared = x * x + y * y + z * z + w * w;
        if (Math.abs(lengthSquared) < GenericMath.FLT_EPSILON) {
            throw new ArithmeticException("Cannot project onto the zero vector");
        }
        float a = this.dot(x, y, z, w) / lengthSquared;
        return Vector4f.from(a * x, a * y, a * z, a * w);
    }

    @Override
    @Nonnull
    public Vector4f pow(float power) {
        return Vector4f.from(Math.pow(this.getX(), power), Math.pow(this.getY(), power), Math.pow(this.getZ(), power), Math.pow(this.getW(), power));
    }

    @Override
    @Nonnull
    public Vector4f ceil() {
        return Vector4f.from(Math.ceil(this.getX()), Math.ceil(this.getY()), Math.ceil(this.getZ()), Math.ceil(this.getW()));
    }

    @Override
    @Nonnull
    public Vector4f floor() {
        return Vector4f.from(GenericMath.floor(this.getX()), GenericMath.floor(this.getY()), GenericMath.floor(this.getZ()), GenericMath.floor(this.getW()));
    }

    @Override
    @Nonnull
    public Vector4f round() {
        return Vector4f.from(Math.round(this.getX()), Math.round(this.getY()), Math.round(this.getZ()), Math.round(this.getW()));
    }

    @Override
    @Nonnull
    public Vector4f abs() {
        return Vector4f.from(Math.abs(this.getX()), Math.abs(this.getY()), Math.abs(this.getZ()), Math.abs(this.getW()));
    }

    @Override
    @Nonnull
    public Vector4f negate() {
        return Vector4f.from(-this.getX(), -this.getY(), -this.getZ(), -this.getW());
    }

    @Override
    @Nonnull
    public Vector4f min(float x, float y, float z, float w) {
        return Vector4f.from(Math.min(this.getX(), x), Math.min(this.getY(), y), Math.min(this.getZ(), z), Math.min(this.getW(), w));
    }

    @Override
    @Nonnull
    public Vector4f max(float x, float y, float z, float w) {
        return Vector4f.from(Math.max(this.getX(), x), Math.max(this.getY(), y), Math.max(this.getZ(), z), Math.max(this.getW(), w));
    }

    @Override
    @Nonnull
    public Vector4f normalize() {
        float length = this.length();
        if (Math.abs(length) < GenericMath.FLT_EPSILON) {
            throw new ArithmeticException("Cannot normalize the zero vector");
        }
        return Vector4f.from(this.getX() / length, this.getY() / length, this.getZ() / length, this.getW() / length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Vector4f)) {
            return false;
        }
        Vector4f vector4 = (Vector4f)o;
        if (Float.compare(vector4.getW(), this.w) != 0) {
            return false;
        }
        if (Float.compare(vector4.getX(), this.x) != 0) {
            return false;
        }
        if (Float.compare(vector4.getY(), this.y) != 0) {
            return false;
        }
        return Float.compare(vector4.getZ(), this.z) == 0;
    }

    public int hashCode() {
        if (!this.hashed) {
            int result = this.x != 0.0f ? Float.hashCode(this.x) : 0;
            result = 31 * result + (this.y != 0.0f ? Float.hashCode(this.y) : 0);
            result = 31 * result + (this.z != 0.0f ? Float.hashCode(this.z) : 0);
            this.hashCode = 31 * result + (this.w != 0.0f ? Float.hashCode(this.w) : 0);
            this.hashed = true;
        }
        return this.hashCode;
    }
}

