/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.level;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;

public class ServerboundTeleportToEntityPacket
implements MinecraftPacket {
    @lombok.NonNull
    private final UUID target;

    public ServerboundTeleportToEntityPacket(ByteBuf in) {
        this.target = MinecraftTypes.readUUID(in);
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writeUUID(out, this.target);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    @lombok.NonNull
    public UUID getTarget() {
        return this.target;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundTeleportToEntityPacket)) {
            return false;
        }
        ServerboundTeleportToEntityPacket other = (ServerboundTeleportToEntityPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$target = this.getTarget();
        UUID other$target = other.getTarget();
        return !(this$target == null ? other$target != null : !((Object)this$target).equals(other$target));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ServerboundTeleportToEntityPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : ((Object)$target).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ServerboundTeleportToEntityPacket(target=" + String.valueOf(this.getTarget()) + ")";
    }

    public @NonNull ServerboundTeleportToEntityPacket withTarget(@lombok.NonNull UUID target) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        return this.target == target ? this : new ServerboundTeleportToEntityPacket(target);
    }

    public ServerboundTeleportToEntityPacket(@lombok.NonNull UUID target) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        this.target = target;
    }
}

