/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java;

import java.util.ArrayList;
import java.util.List;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.UnlockedRecipesPacket;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.ClientboundRecipeBookRemovePacket;

@Translator(packet=ClientboundRecipeBookRemovePacket.class)
public class JavaRecipeBookRemoveTranslator
extends PacketTranslator<ClientboundRecipeBookRemovePacket> {
    @Override
    public void translate(GeyserSession session, ClientboundRecipeBookRemovePacket packet) {
        List<String> recipes = this.getBedrockRecipes(session, packet.getRecipes());
        if (recipes.isEmpty()) {
            return;
        }
        UnlockedRecipesPacket recipesPacket = new UnlockedRecipesPacket();
        recipesPacket.setAction(UnlockedRecipesPacket.ActionType.REMOVE_UNLOCKED);
        recipesPacket.getUnlockedRecipes().addAll(recipes);
        session.sendUpstreamPacket(recipesPacket);
    }

    private List<String> getBedrockRecipes(GeyserSession session, int[] javaRecipeIds) {
        ArrayList<String> recipes = new ArrayList<String>();
        for (int javaIdentifier : javaRecipeIds) {
            List bedrockRecipes = (List)session.getJavaToBedrockRecipeIds().get(javaIdentifier);
            if (bedrockRecipes == null) continue;
            recipes.addAll(bedrockRecipes);
        }
        return recipes;
    }
}

