/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.type;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.TrimMaterial;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.TrimPattern;
import org.geysermc.geyser.translator.item.BedrockItemBuilder;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.ArmorTrim;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;

public class ArmorItem
extends Item {
    public ArmorItem(String javaIdentifier, Item.Builder builder) {
        super(javaIdentifier, builder);
    }

    @Override
    public void translateComponentsToBedrock(@NonNull GeyserSession session, @NonNull DataComponents components, @NonNull BedrockItemBuilder builder) {
        super.translateComponentsToBedrock(session, components, builder);
        ArmorTrim trim = components.get(DataComponentTypes.TRIM);
        if (trim != null) {
            TrimMaterial material = session.getRegistryCache().trimMaterials().byId(trim.material().id());
            TrimPattern pattern = session.getRegistryCache().trimPatterns().byId(trim.pattern().id());
            if (!ArmorItem.getNamespace(material.getMaterialId()).equals("minecraft") || !ArmorItem.getNamespace(pattern.getPatternId()).equals("minecraft")) {
                return;
            }
            NbtMapBuilder trimBuilder = NbtMap.builder();
            trimBuilder.put("Material", (Object)material.getMaterialId());
            trimBuilder.put("Pattern", (Object)pattern.getPatternId());
            builder.putCompound("Trim", trimBuilder.build());
        }
    }

    private static String getNamespace(String identifier) {
        int i = identifier.indexOf(58);
        if (i >= 0) {
            return identifier.substring(0, i);
        }
        return "minecraft";
    }
}

