/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.entity.player;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3f;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.entity.type.player.PlayerEntity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.PlayerListPacket;
import org.geysermc.geyser.skin.SkinManager;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.PlayerListUtils;
import org.geysermc.mcprotocollib.auth.GameProfile;
import org.geysermc.mcprotocollib.protocol.data.game.PlayerListEntry;
import org.geysermc.mcprotocollib.protocol.data.game.PlayerListEntryAction;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.ClientboundPlayerInfoUpdatePacket;

@Translator(packet=ClientboundPlayerInfoUpdatePacket.class)
public class JavaPlayerInfoUpdateTranslator
extends PacketTranslator<ClientboundPlayerInfoUpdatePacket> {
    @Override
    public void translate(GeyserSession session, ClientboundPlayerInfoUpdatePacket packet) {
        EnumSet<PlayerListEntryAction> actions = packet.getActions();
        if (actions.contains((Object)PlayerListEntryAction.ADD_PLAYER)) {
            for (PlayerListEntry entry : packet.getEntries()) {
                PlayerEntity playerEntity;
                boolean self;
                @Nullable GameProfile profile = entry.getProfile();
                UUID id = entry.getProfileId();
                String name = null;
                String texturesProperty = null;
                if (profile != null) {
                    name = profile.getName();
                    GameProfile.Property textures = profile.getProperty("textures");
                    if (textures != null) {
                        texturesProperty = textures.getValue();
                    }
                }
                if (self = id.equals(session.getPlayerEntity().getUuid())) {
                    playerEntity = session.getPlayerEntity();
                } else {
                    playerEntity = new PlayerEntity(session, -1, session.getEntityCache().getNextEntityId().incrementAndGet(), id, Vector3f.ZERO, Vector3f.ZERO, 0.0f, 0.0f, 0.0f, name, texturesProperty);
                    session.getEntityCache().addPlayerEntity(playerEntity);
                }
                playerEntity.setUsername(name);
                playerEntity.setTexturesProperty(texturesProperty);
                if (!self) continue;
                SkinManager.requestAndHandleSkinAndCape(playerEntity, session, skinAndCape -> GeyserImpl.getInstance().getLogger().debug("Loaded Local Bedrock Java Skin Data for " + session.getClientData().getUsername()));
            }
        }
        if (actions.contains((Object)PlayerListEntryAction.UPDATE_LISTED)) {
            ArrayList<PlayerListPacket.Entry> toAdd = new ArrayList<PlayerListPacket.Entry>();
            ArrayList<PlayerListPacket.Entry> toRemove = new ArrayList<PlayerListPacket.Entry>();
            for (PlayerListEntry entry : packet.getEntries()) {
                PlayerEntity entity = session.getEntityCache().getPlayerEntity(entry.getProfileId());
                if (entity == null) {
                    session.getGeyser().getLogger().debug("Ignoring player info update for " + String.valueOf(entry.getProfileId()));
                    continue;
                }
                if (entry.isListed()) {
                    PlayerListPacket.Entry playerListEntry = SkinManager.buildCachedEntry(session, entity);
                    toAdd.add(playerListEntry);
                    continue;
                }
                toRemove.add(new PlayerListPacket.Entry(entity.getTabListUuid()));
            }
            if (!toAdd.isEmpty()) {
                PlayerListUtils.batchSendPlayerList(session, toAdd, PlayerListPacket.Action.ADD);
            }
            if (!toRemove.isEmpty()) {
                PlayerListUtils.batchSendPlayerList(session, toRemove, PlayerListPacket.Action.REMOVE);
            }
        }
    }
}

