/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.player;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.protocol.bedrock.data.Ability;
import org.cloudburstmc.protocol.bedrock.data.AbilityLayer;
import org.cloudburstmc.protocol.bedrock.data.GameType;
import org.cloudburstmc.protocol.bedrock.data.PlayerPermission;
import org.cloudburstmc.protocol.bedrock.data.command.CommandPermission;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityLinkData;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.cloudburstmc.protocol.bedrock.packet.AddPlayerPacket;
import org.cloudburstmc.protocol.bedrock.packet.MovePlayerPacket;
import org.cloudburstmc.protocol.bedrock.packet.SetEntityLinkPacket;
import org.cloudburstmc.protocol.bedrock.packet.UpdateAttributesPacket;
import org.geysermc.geyser.api.entity.type.player.GeyserPlayerEntity;
import org.geysermc.geyser.entity.EntityDefinitions;
import org.geysermc.geyser.entity.attribute.GeyserAttributeType;
import org.geysermc.geyser.entity.type.LivingEntity;
import org.geysermc.geyser.entity.type.living.animal.tameable.ParrotEntity;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.util.ChunkUtils;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.EntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.Pose;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.BooleanEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.ByteEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.FloatEntityMetadata;

public class PlayerEntity
extends LivingEntity
implements GeyserPlayerEntity {
    public static final float SNEAKING_POSE_HEIGHT = 1.5f;
    protected static final List<AbilityLayer> BASE_ABILITY_LAYER;
    private String username;
    private String cachedScore = "";
    private boolean scoreVisible = true;
    private @Nullable String texturesProperty;
    private @Nullable Vector3i bedPosition;
    private @Nullable ParrotEntity leftParrot;
    private @Nullable ParrotEntity rightParrot;
    private boolean listed = false;

    public PlayerEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw, String username, @Nullable String texturesProperty) {
        super(session, entityId, geyserId, uuid, EntityDefinitions.PLAYER, position, motion, yaw, pitch, headYaw);
        this.username = username;
        this.nametag = username;
        this.texturesProperty = texturesProperty;
    }

    @Override
    protected void initializeMetadata() {
        super.initializeMetadata();
        this.dirtyMetadata.put(EntityDataTypes.MARK_VARIANT, 255);
    }

    @Override
    public void spawnEntity() {
        AddPlayerPacket addPlayerPacket = new AddPlayerPacket();
        addPlayerPacket.setUuid(this.uuid);
        addPlayerPacket.setUsername(this.username);
        addPlayerPacket.setRuntimeEntityId(this.geyserId);
        addPlayerPacket.setUniqueEntityId(this.geyserId);
        addPlayerPacket.setPosition(this.position.sub(0.0f, this.definition.offset(), 0.0f));
        addPlayerPacket.setRotation(this.getBedrockRotation());
        addPlayerPacket.setMotion(this.motion);
        addPlayerPacket.setHand(this.hand);
        addPlayerPacket.getAdventureSettings().setCommandPermission(CommandPermission.ANY);
        addPlayerPacket.getAdventureSettings().setPlayerPermission(PlayerPermission.MEMBER);
        addPlayerPacket.setDeviceId("");
        addPlayerPacket.setPlatformChatId("");
        addPlayerPacket.setGameType(GameType.SURVIVAL);
        addPlayerPacket.setAbilityLayers(BASE_ABILITY_LAYER);
        addPlayerPacket.getMetadata().putFlags(this.flags);
        this.dirtyMetadata.put(EntityDataTypes.NAMETAG_ALWAYS_SHOW, (byte)1);
        this.dirtyMetadata.apply(addPlayerPacket.getMetadata());
        this.setFlagsDirty(false);
        this.valid = true;
        this.session.sendUpstreamPacket(addPlayerPacket);
    }

    @Override
    public void despawnEntity() {
        super.despawnEntity();
        this.resetMetadata();
        this.nametag = this.username;
        this.equipment.clear();
        this.hand = ItemData.AIR;
        this.offhand = ItemData.AIR;
        this.boots = ItemData.AIR;
        this.leggings = ItemData.AIR;
        this.chestplate = ItemData.AIR;
        this.helmet = ItemData.AIR;
    }

    public void resetMetadata() {
        this.flags.clear();
        this.initializeMetadata();
        this.setParrot(null, true);
        this.setParrot(null, false);
    }

    public void sendPlayer() {
        if (this.session.getEntityCache().getPlayerEntity(this.uuid) == null) {
            return;
        }
        this.session.getEntityCache().spawnEntity(this);
    }

    @Override
    public void moveAbsolute(Vector3f position, float yaw, float pitch, float headYaw, boolean isOnGround, boolean teleported) {
        this.setPosition(position);
        this.setYaw(yaw);
        this.setPitch(pitch);
        this.setHeadYaw(headYaw);
        this.setOnGround(isOnGround);
        MovePlayerPacket movePlayerPacket = new MovePlayerPacket();
        movePlayerPacket.setRuntimeEntityId(this.geyserId);
        movePlayerPacket.setPosition(this.position);
        movePlayerPacket.setRotation(this.getBedrockRotation());
        movePlayerPacket.setOnGround(isOnGround);
        movePlayerPacket.setMode(teleported ? MovePlayerPacket.Mode.TELEPORT : MovePlayerPacket.Mode.NORMAL);
        if (teleported) {
            movePlayerPacket.setTeleportationCause(MovePlayerPacket.TeleportationCause.UNKNOWN);
        }
        this.session.sendUpstreamPacket(movePlayerPacket);
        if (teleported) {
            this.updateHeadLookRotation(headYaw);
        }
        if (this.leftParrot != null) {
            this.leftParrot.moveAbsolute(position, yaw, pitch, headYaw, true, teleported);
        }
        if (this.rightParrot != null) {
            this.rightParrot.moveAbsolute(position, yaw, pitch, headYaw, true, teleported);
        }
    }

    @Override
    public void moveRelative(double relX, double relY, double relZ, float yaw, float pitch, float headYaw, boolean isOnGround) {
        this.setYaw(yaw);
        this.setPitch(pitch);
        this.setHeadYaw(headYaw);
        this.position = Vector3f.from((double)this.position.getX() + relX, (double)this.position.getY() + relY, (double)this.position.getZ() + relZ);
        this.setOnGround(isOnGround);
        MovePlayerPacket movePlayerPacket = new MovePlayerPacket();
        movePlayerPacket.setRuntimeEntityId(this.geyserId);
        movePlayerPacket.setPosition(this.position);
        movePlayerPacket.setRotation(this.getBedrockRotation());
        movePlayerPacket.setOnGround(isOnGround);
        movePlayerPacket.setMode(MovePlayerPacket.Mode.NORMAL);
        if (this.getFlag(EntityFlag.SLEEPING) && this.bedPosition != null && (this.bedPosition.getY() == 0 || this.bedPosition.distanceSquared(this.position.toInt()) > 4)) {
            movePlayerPacket.setPosition(Vector3f.from(this.position.getX(), this.position.getY() - this.definition.offset() + 0.2f, this.position.getZ()));
            movePlayerPacket.setMode(MovePlayerPacket.Mode.TELEPORT);
            movePlayerPacket.setTeleportationCause(MovePlayerPacket.TeleportationCause.UNKNOWN);
        }
        this.session.sendUpstreamPacket(movePlayerPacket);
        if (this.leftParrot != null) {
            this.leftParrot.moveRelative(relX, relY, relZ, yaw, pitch, headYaw, true);
        }
        if (this.rightParrot != null) {
            this.rightParrot.moveRelative(relX, relY, relZ, yaw, pitch, headYaw, true);
        }
    }

    @Override
    public void setPosition(Vector3f position) {
        if (this.bedPosition != null) {
            super.setPosition(position.up(0.2f));
        } else {
            super.setPosition(position.add(0.0f, this.definition.offset(), 0.0f));
        }
    }

    @Override
    public @Nullable Vector3i setBedPosition(EntityMetadata<Optional<Vector3i>, ?> entityMetadata) {
        this.bedPosition = super.setBedPosition(entityMetadata);
        if (this.bedPosition == null) {
            this.dirtyMetadata.put(EntityDataTypes.PLAYER_FLAGS, (byte)0);
            return null;
        }
        this.setPosition(this.bedPosition.toFloat());
        int bed = this.session.getGeyser().getWorldManager().getBlockAt(this.session, this.bedPosition);
        ChunkUtils.updateBlock(this.session, bed, this.bedPosition);
        this.dirtyMetadata.put(EntityDataTypes.PLAYER_FLAGS, (byte)2);
        return this.bedPosition;
    }

    public void setAbsorptionHearts(FloatEntityMetadata entityMetadata) {
        UpdateAttributesPacket attributesPacket = new UpdateAttributesPacket();
        attributesPacket.setRuntimeEntityId(this.geyserId);
        attributesPacket.setAttributes(Collections.singletonList(GeyserAttributeType.ABSORPTION.getAttribute(entityMetadata.getPrimitiveValue())));
        this.session.sendUpstreamPacket(attributesPacket);
    }

    public void setSkinVisibility(ByteEntityMetadata entityMetadata) {
        this.dirtyMetadata.put(EntityDataTypes.MARK_VARIANT, ~entityMetadata.getPrimitiveValue() & 0xFF);
    }

    public void setLeftParrot(EntityMetadata<NbtMap, ?> entityMetadata) {
        this.setParrot(entityMetadata.getValue(), true);
    }

    public void setRightParrot(EntityMetadata<NbtMap, ?> entityMetadata) {
        this.setParrot(entityMetadata.getValue(), false);
    }

    protected void setParrot(NbtMap tag, boolean isLeft) {
        if (tag != null && !tag.isEmpty()) {
            if (isLeft && this.leftParrot != null || !isLeft && this.rightParrot != null) {
                return;
            }
            ParrotEntity parrot = new ParrotEntity(this.session, 0, this.session.getEntityCache().getNextEntityId().incrementAndGet(), null, EntityDefinitions.PARROT, this.position, this.motion, this.getYaw(), this.getPitch(), this.getHeadYaw());
            parrot.spawnEntity();
            parrot.getDirtyMetadata().put(EntityDataTypes.VARIANT, (Integer)tag.get("Variant"));
            float offset = isLeft ? 0.4f : -0.4f;
            parrot.getDirtyMetadata().put(EntityDataTypes.SEAT_OFFSET, Vector3f.from((double)offset, -0.22, -0.1));
            parrot.getDirtyMetadata().put(EntityDataTypes.SEAT_LOCK_RIDER_ROTATION, true);
            parrot.updateBedrockMetadata();
            SetEntityLinkPacket linkPacket = new SetEntityLinkPacket();
            EntityLinkData.Type type = isLeft ? EntityLinkData.Type.RIDER : EntityLinkData.Type.PASSENGER;
            linkPacket.setEntityLink(new EntityLinkData(this.geyserId, parrot.getGeyserId(), type, false, false, 0.0f));
            this.session.scheduleInEventLoop(() -> this.session.sendUpstreamPacket(linkPacket), 500L, TimeUnit.MILLISECONDS);
            if (isLeft) {
                this.leftParrot = parrot;
            } else {
                this.rightParrot = parrot;
            }
        } else {
            ParrotEntity parrot;
            ParrotEntity parrotEntity = parrot = isLeft ? this.leftParrot : this.rightParrot;
            if (parrot != null) {
                parrot.despawnEntity();
                if (isLeft) {
                    this.leftParrot = null;
                } else {
                    this.rightParrot = null;
                }
            }
        }
    }

    @Override
    public String getDisplayName() {
        return this.username;
    }

    @Override
    public void setDisplayName(EntityMetadata<Optional<Component>, ?> entityMetadata) {
    }

    @Override
    public String teamIdentifier() {
        return this.username;
    }

    @Override
    protected void setNametag(@Nullable String nametag, boolean fromDisplayName) {
        if (nametag == null && !fromDisplayName) {
            nametag = this.username;
        }
        super.setNametag(nametag, fromDisplayName);
    }

    @Override
    public void setDisplayNameVisible(BooleanEntityMetadata entityMetadata) {
    }

    public void setBelowNameText(String text) {
        if (text == null) {
            text = "";
        }
        boolean changed = !Objects.equals(this.cachedScore, text);
        this.cachedScore = text;
        if (this.isScoreVisible() && changed) {
            this.dirtyMetadata.put(EntityDataTypes.SCORE, text);
        }
    }

    @Override
    protected void scoreVisibility(boolean show) {
        boolean visibilityChanged = this.scoreVisible != show;
        this.scoreVisible = show;
        if (!visibilityChanged) {
            return;
        }
        if (this.cachedScore.isEmpty()) {
            return;
        }
        this.dirtyMetadata.put(EntityDataTypes.SCORE, show ? this.cachedScore : "");
    }

    @Override
    public void setPose(Pose pose) {
        super.setPose(pose);
        this.setFlag(EntityFlag.SWIMMING, false);
        this.setFlag(EntityFlag.CRAWLING, false);
        if (pose == Pose.SWIMMING) {
            if (this.session.getGeyser().getWorldManager().blockAt(this.session, this.position().toInt()).is(Blocks.WATER)) {
                this.setFlag(EntityFlag.SWIMMING, true);
            } else {
                this.setFlag(EntityFlag.CRAWLING, true);
                this.updateRotation(this.yaw, 0.0f, this.onGround);
            }
        }
    }

    @Override
    public void setPitch(float pitch) {
        super.setPitch(this.getFlag(EntityFlag.CRAWLING) ? 0.0f : pitch);
    }

    @Override
    public void setDimensionsFromPose(Pose pose) {
        float width;
        float height;
        switch (pose) {
            case SNEAKING: {
                height = 1.5f;
                width = this.definition.width();
                break;
            }
            case FALL_FLYING: 
            case SPIN_ATTACK: 
            case SWIMMING: {
                height = 0.6f;
                width = this.definition.width();
                break;
            }
            case DYING: {
                height = 0.2f;
                width = 0.2f;
                break;
            }
            default: {
                super.setDimensionsFromPose(pose);
                return;
            }
        }
        this.setBoundingBoxWidth(width);
        this.setBoundingBoxHeight(height);
    }

    public UUID getTabListUuid() {
        return this.getUuid();
    }

    @Override
    public Vector3f position() {
        return this.position.down(this.definition.offset());
    }

    public String getUsername() {
        return this.username;
    }

    public String getCachedScore() {
        return this.cachedScore;
    }

    public boolean isScoreVisible() {
        return this.scoreVisible;
    }

    public @Nullable String getTexturesProperty() {
        return this.texturesProperty;
    }

    public @Nullable Vector3i getBedPosition() {
        return this.bedPosition;
    }

    public @Nullable ParrotEntity getLeftParrot() {
        return this.leftParrot;
    }

    public @Nullable ParrotEntity getRightParrot() {
        return this.rightParrot;
    }

    public boolean isListed() {
        return this.listed;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setCachedScore(String cachedScore) {
        this.cachedScore = cachedScore;
    }

    public void setScoreVisible(boolean scoreVisible) {
        this.scoreVisible = scoreVisible;
    }

    public void setTexturesProperty(@Nullable String texturesProperty) {
        this.texturesProperty = texturesProperty;
    }

    public void setListed(boolean listed) {
        this.listed = listed;
    }

    static {
        AbilityLayer abilityLayer = new AbilityLayer();
        abilityLayer.setLayerType(AbilityLayer.Type.BASE);
        Ability[] abilities = Ability.values();
        Collections.addAll(abilityLayer.getAbilitiesSet(), abilities);
        Collections.addAll(abilityLayer.getAbilityValues(), abilities);
        BASE_ABILITY_LAYER = Collections.singletonList(abilityLayer);
    }
}

