/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.inventory.recipe;

import org.cloudburstmc.protocol.bedrock.data.TrimMaterial;
import org.cloudburstmc.protocol.bedrock.data.TrimPattern;
import org.cloudburstmc.protocol.bedrock.data.inventory.descriptor.ItemDescriptorWithCount;
import org.cloudburstmc.protocol.bedrock.data.inventory.descriptor.ItemTagDescriptor;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.Component;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.format.TextColor;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.cache.registry.RegistryEntryContext;
import org.geysermc.geyser.translator.text.MessageTranslator;

public final class TrimRecipe {
    public static final String ID = "minecraft:smithing_armor_trim";
    public static final ItemDescriptorWithCount BASE = TrimRecipe.tagDescriptor("minecraft:trimmable_armors");
    public static final ItemDescriptorWithCount ADDITION = TrimRecipe.tagDescriptor("minecraft:trim_materials");
    public static final ItemDescriptorWithCount TEMPLATE = TrimRecipe.tagDescriptor("minecraft:trim_templates");

    public static TrimMaterial readTrimMaterial(RegistryEntryContext context) {
        String key = context.id().asMinimalString();
        String colorTag = context.data().getCompound("description").getString("color");
        TextColor color = TextColor.fromHexString(colorTag);
        String legacy = MessageTranslator.convertMessage(Component.space().color(color));
        String itemIdentifier = context.data().getString("ingredient");
        ItemMapping itemMapping = context.session().getItemMappings().getMapping(itemIdentifier);
        if (itemMapping == null) {
            itemMapping = ItemMapping.AIR;
        }
        return new TrimMaterial(key, legacy.substring(2).trim(), itemMapping.getBedrockIdentifier());
    }

    public static TrimPattern readTrimPattern(RegistryEntryContext context) {
        String key = context.id().asMinimalString();
        String itemIdentifier = context.data().getString("template_item");
        ItemMapping itemMapping = context.session().getItemMappings().getMapping(itemIdentifier);
        if (itemMapping == null) {
            itemMapping = ItemMapping.AIR;
        }
        return new TrimPattern(itemMapping.getBedrockIdentifier(), key);
    }

    private TrimRecipe() {
    }

    private static ItemDescriptorWithCount tagDescriptor(String tag) {
        return new ItemDescriptorWithCount(new ItemTagDescriptor(tag), 1);
    }
}

