/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.httpclient.executor;

import java.io.Closeable;
import java.io.IOException;
import java.net.CookieManager;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nonnull;
import net.lenni0451.commons.httpclient.HttpClient;
import net.lenni0451.commons.httpclient.HttpResponse;
import net.lenni0451.commons.httpclient.content.HttpContent;
import net.lenni0451.commons.httpclient.executor.RequestExecutor;
import net.lenni0451.commons.httpclient.proxy.ProxyType;
import net.lenni0451.commons.httpclient.requests.HttpContentRequest;
import net.lenni0451.commons.httpclient.utils.IgnoringTrustManager;
import net.lenni0451.commons.httpclient.utils.URLWrapper;

public class HttpClientExecutor
extends RequestExecutor {
    public HttpClientExecutor(HttpClient client) {
        super(client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public HttpResponse execute(@Nonnull net.lenni0451.commons.httpclient.requests.HttpRequest request) throws IOException {
        ExecutorService executor = Executors.newCachedThreadPool();
        java.net.http.HttpClient httpClient = null;
        try {
            java.net.http.HttpResponse<byte[]> response;
            httpClient = this.buildClient(request, executor);
            HttpRequest httpRequest = this.buildRequest(request);
            try {
                response = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofByteArray());
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
            HttpResponse httpResponse = new HttpResponse(new URLWrapper(response.uri()).toURL(), response.statusCode(), response.body(), response.headers().map());
            return httpResponse;
        }
        finally {
            executor.shutdownNow();
            if (httpClient instanceof Closeable) {
                ((Closeable)((Object)httpClient)).close();
            }
        }
    }

    private java.net.http.HttpClient buildClient(net.lenni0451.commons.httpclient.requests.HttpRequest request, Executor executor) throws IOException {
        HttpClient.Builder builder = java.net.http.HttpClient.newBuilder().executor(executor);
        CookieManager cookieManager = this.getCookieManager(request);
        if (cookieManager != null) {
            builder.cookieHandler(cookieManager);
        }
        if (this.isIgnoreInvalidSSL(request)) {
            builder.sslContext(IgnoringTrustManager.makeIgnoringSSLContext());
        }
        builder.connectTimeout(Duration.ofMillis(this.client.getConnectTimeout()));
        switch (request.getFollowRedirects()) {
            case NOT_SET: {
                builder.followRedirects(this.client.isFollowRedirects() ? HttpClient.Redirect.NORMAL : HttpClient.Redirect.NEVER);
                break;
            }
            case FOLLOW: {
                builder.followRedirects(HttpClient.Redirect.NORMAL);
                break;
            }
            case IGNORE: {
                builder.followRedirects(HttpClient.Redirect.NEVER);
            }
        }
        if (this.client.getProxyHandler().isProxySet()) {
            if (!ProxyType.HTTP.equals((Object)this.client.getProxyHandler().getProxyType())) {
                throw new UnsupportedOperationException("The Java 11 HttpClient only supports HTTP proxies");
            }
            builder.proxy(this.client.getProxyHandler().getProxySelector());
            if (this.client.getProxyHandler().getUsername() != null && this.client.getProxyHandler().getPassword() != null) {
                builder.authenticator(this.client.getProxyHandler().getProxyAuthenticator());
            }
        }
        return builder.build();
    }

    private HttpRequest buildRequest(net.lenni0451.commons.httpclient.requests.HttpRequest request) throws IOException {
        HttpRequest.Builder builder = HttpRequest.newBuilder();
        builder.uri(new URLWrapper(request.getURL()).toURI());
        builder.timeout(Duration.ofMillis(this.client.getReadTimeout()));
        if (request instanceof HttpContentRequest && ((HttpContentRequest)request).hasContent()) {
            HttpContent content = ((HttpContentRequest)request).getContent();
            builder.method(request.getMethod(), HttpRequest.BodyPublishers.ofByteArray(content.getAsBytes()));
        } else {
            builder.method(request.getMethod(), HttpRequest.BodyPublishers.noBody());
        }
        for (Map.Entry<String, List<String>> entry : this.getHeaders(request, null).entrySet()) {
            if (entry.getKey().equalsIgnoreCase("Content-Length")) continue;
            for (String value : entry.getValue()) {
                builder.header(entry.getKey(), value);
            }
        }
        return builder.build();
    }
}

