/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.cache.tags;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import net.kyori.adventure.key.Key;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.nbt.NbtMap;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.platform.velocity.shaded.it.unimi.dsi.fastutil.ints.IntArrays;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.TagCache;
import org.geysermc.geyser.session.cache.registry.JavaRegistryKey;
import org.geysermc.geyser.session.cache.tags.Tag;
import org.geysermc.geyser.util.MinecraftKey;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.HolderSet;

public final class GeyserHolderSet<T> {
    private final JavaRegistryKey<T> registry;
    private final @Nullable Tag<T> tag;
    private final int @Nullable [] holders;
    private final @Nullable List<T> inline;

    private GeyserHolderSet(JavaRegistryKey<T> registry) {
        this(registry, IntArrays.EMPTY_ARRAY);
    }

    public GeyserHolderSet(JavaRegistryKey<T> registry, int @NonNull [] holders) {
        this(registry, null, holders, null);
    }

    public GeyserHolderSet(JavaRegistryKey<T> registry, @NonNull Tag<T> tagId) {
        this(registry, tagId, null, null);
    }

    public GeyserHolderSet(JavaRegistryKey<T> registry, @NonNull List<T> inline) {
        this(registry, null, null, inline);
    }

    private GeyserHolderSet(JavaRegistryKey<T> registry, @Nullable Tag<T> tag, int @Nullable [] holders, @Nullable List<T> inline) {
        this.registry = registry;
        this.tag = tag;
        this.holders = holders;
        this.inline = inline;
    }

    public static <T> GeyserHolderSet<T> fromHolderSet(JavaRegistryKey<T> registry, @NonNull HolderSet holderSet) {
        Tag<T> tag = holderSet.getLocation() == null ? null : new Tag<T>(registry, holderSet.getLocation());
        return new GeyserHolderSet<T>(registry, tag, holderSet.getHolders(), null);
    }

    public List<T> resolve(GeyserSession session) {
        if (this.inline != null) {
            return this.inline;
        }
        return TagCache.mapRawArray(session, this.resolveRaw(session.getTagCache()), this.registry);
    }

    public int[] resolveRaw(TagCache tagCache) {
        if (this.inline != null) {
            throw new IllegalStateException("Tried to resolve network IDs of a GeyserHolderSet(registry=" + String.valueOf(this.registry) + ") with inline elements!");
        }
        if (this.holders != null) {
            return this.holders;
        }
        return tagCache.getRaw(Objects.requireNonNull(this.tag, "HolderSet must have a tag if it doesn't have a list of IDs"));
    }

    public static <T> GeyserHolderSet<T> readHolderSet(GeyserSession session, JavaRegistryKey<T> registry, @Nullable Object holderSet) {
        return GeyserHolderSet.readHolderSet(registry, holderSet, (Key key) -> registry.networkId(session, (Key)key));
    }

    public static <T> GeyserHolderSet<T> readHolderSet(JavaRegistryKey<T> registry, @Nullable Object holderSet, ToIntFunction<Key> idMapper) {
        return GeyserHolderSet.readHolderSet(registry, holderSet, idMapper, null);
    }

    public static <T> GeyserHolderSet<T> readHolderSet(JavaRegistryKey<T> registry, @Nullable Object holderSet, ToIntFunction<Key> idMapper, @Nullable Function<NbtMap, T> reader) {
        if (holderSet == null) {
            return new GeyserHolderSet<T>(registry);
        }
        if (holderSet instanceof NbtMap) {
            NbtMap singleInlineElement = (NbtMap)holderSet;
            if (reader != null) {
                return new GeyserHolderSet<T>(registry, List.of(reader.apply(singleInlineElement)));
            }
        }
        if (holderSet instanceof String) {
            String elementOrTag = (String)holderSet;
            if (elementOrTag.startsWith("#")) {
                return new GeyserHolderSet<T>(registry, new Tag<T>(registry, MinecraftKey.key(elementOrTag.substring(1))));
            }
            if (elementOrTag.isEmpty()) {
                return new GeyserHolderSet<T>(registry);
            }
            return new GeyserHolderSet<T>(registry, new int[]{idMapper.applyAsInt(MinecraftKey.key(elementOrTag))});
        }
        if (holderSet instanceof List) {
            List list = (List)holderSet;
            if (list.isEmpty()) {
                return new GeyserHolderSet<T>(registry);
            }
            if (list.get(0) instanceof NbtMap) {
                if (reader != null) {
                    return new GeyserHolderSet<T>(registry, list.stream().map(o -> (NbtMap)o).map(reader).toList());
                }
            } else {
                return new GeyserHolderSet<T>(registry, list.stream().map(o -> (String)o).map(Key::key).mapToInt(idMapper).toArray());
            }
        }
        String expected = reader == null ? "either a tag, a string ID, or a list of string IDs" : "either a tag, a string ID, an inline registry element, a list of string IDs, or a list of inline registry elements";
        GeyserImpl.getInstance().getLogger().warning("Failed parsing HolderSet for registry + " + String.valueOf(registry) + "! Expected " + expected + ", found " + String.valueOf(holderSet));
        return new GeyserHolderSet<T>(registry);
    }

    public JavaRegistryKey<T> getRegistry() {
        return this.registry;
    }

    public @Nullable Tag<T> getTag() {
        return this.tag;
    }

    public int @Nullable [] getHolders() {
        return this.holders;
    }

    public @Nullable List<T> getInline() {
        return this.inline;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeyserHolderSet)) {
            return false;
        }
        GeyserHolderSet other = (GeyserHolderSet)o;
        JavaRegistryKey<T> this$registry = this.getRegistry();
        JavaRegistryKey<T> other$registry = other.getRegistry();
        if (this$registry == null ? other$registry != null : !((Object)this$registry).equals(other$registry)) {
            return false;
        }
        Tag<T> this$tag = this.getTag();
        Tag<T> other$tag = other.getTag();
        if (this$tag == null ? other$tag != null : !((Object)this$tag).equals(other$tag)) {
            return false;
        }
        if (!Arrays.equals(this.getHolders(), other.getHolders())) {
            return false;
        }
        List<T> this$inline = this.getInline();
        List<T> other$inline = other.getInline();
        return !(this$inline == null ? other$inline != null : !((Object)this$inline).equals(other$inline));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JavaRegistryKey<T> $registry = this.getRegistry();
        result = result * 59 + ($registry == null ? 43 : ((Object)$registry).hashCode());
        Tag<T> $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : ((Object)$tag).hashCode());
        result = result * 59 + Arrays.hashCode(this.getHolders());
        List<T> $inline = this.getInline();
        result = result * 59 + ($inline == null ? 43 : ((Object)$inline).hashCode());
        return result;
    }

    public String toString() {
        return "GeyserHolderSet(registry=" + String.valueOf(this.getRegistry()) + ", tag=" + String.valueOf(this.getTag()) + ", holders=" + Arrays.toString(this.getHolders()) + ", inline=" + String.valueOf(this.getInline()) + ")";
    }
}

