/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.event.subscribe.impl;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.event.PostOrder;
import org.geysermc.event.subscribe.Subscriber;

public abstract class SubscriberImpl<E>
implements Subscriber<E> {
    protected final Class<E> eventClass;
    protected final PostOrder postOrder;
    protected final boolean ignoreCancelled;
    protected final Consumer<E> handler;

    public SubscriberImpl(@NonNull Class<E> eventClass, @NonNull Consumer<E> handler, @NonNull PostOrder postOrder) {
        this.eventClass = eventClass;
        this.postOrder = postOrder;
        this.ignoreCancelled = false;
        this.handler = handler;
    }

    public <H> SubscriberImpl(Class<E> eventClass, PostOrder postOrder, boolean ignoreCancelled, H handlerInstance, BiConsumer<H, E> handler) {
        this.eventClass = eventClass;
        this.postOrder = postOrder;
        this.ignoreCancelled = ignoreCancelled;
        this.handler = event -> handler.accept(handlerInstance, event);
    }

    @Override
    public @NonNull Class<E> eventClass() {
        return this.eventClass;
    }

    @Override
    public @NonNull PostOrder order() {
        return this.postOrder;
    }

    @Override
    public boolean ignoreCancelled() {
        return this.ignoreCancelled;
    }

    @Override
    public void invoke(@NonNull E event) throws Throwable {
        this.handler.accept(event);
    }
}

