/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.impl.camera;

import java.awt.Color;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.common.value.qual.IntRange;
import org.geysermc.geyser.api.bedrock.camera.CameraFade;

public record GeyserCameraFade(Color color, float fadeInSeconds, float fadeHoldSeconds, float fadeOutSeconds) implements CameraFade
{

    public static class Builder
    implements CameraFade.Builder {
        private Color color;
        private float fadeInSeconds;
        private float fadeHoldSeconds;
        private float fadeOutSeconds;

        @Override
        public CameraFade.Builder color(@NonNull Color color) {
            Objects.requireNonNull(color, "color cannot be null!");
            this.color = color;
            return this;
        }

        @Override
        public CameraFade.Builder fadeInSeconds(@IntRange(from=0L, to=10L) float fadeInSeconds) {
            if (fadeInSeconds < 0.0f) {
                throw new IllegalArgumentException("Fade in seconds must be at least 0 seconds");
            }
            if (fadeInSeconds > 10.0f) {
                throw new IllegalArgumentException("Fade in seconds must be at most 10 seconds");
            }
            this.fadeInSeconds = fadeInSeconds;
            return this;
        }

        @Override
        public CameraFade.Builder fadeHoldSeconds(@IntRange(from=0L, to=10L) float fadeHoldSeconds) {
            if (fadeHoldSeconds < 0.0f) {
                throw new IllegalArgumentException("Fade hold seconds must be at least 0 seconds");
            }
            if (fadeHoldSeconds > 10.0f) {
                throw new IllegalArgumentException("Fade hold seconds must be at most 10 seconds");
            }
            this.fadeHoldSeconds = fadeHoldSeconds;
            return this;
        }

        @Override
        public CameraFade.Builder fadeOutSeconds(@IntRange(from=0L, to=10L) float fadeOutSeconds) {
            if (fadeOutSeconds < 0.0f) {
                throw new IllegalArgumentException("Fade out seconds must be at least 0 seconds");
            }
            if (fadeOutSeconds > 10.0f) {
                throw new IllegalArgumentException("Fade out seconds must be at most 10 seconds");
            }
            this.fadeOutSeconds = fadeOutSeconds;
            return this;
        }

        @Override
        public CameraFade build() {
            Objects.requireNonNull(this.color, "color must be non null!");
            if (this.fadeInSeconds + this.fadeHoldSeconds + this.fadeOutSeconds < 0.5f) {
                throw new IllegalArgumentException("Total fade time (in, hold, out) must be at least 0.5 seconds");
            }
            return new GeyserCameraFade(this.color, this.fadeInSeconds, this.fadeHoldSeconds, this.fadeOutSeconds);
        }
    }
}

