/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.cache.registry;

import javax.annotation.Nullable;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.key.Key;
import org.geysermc.geyser.session.GeyserSession;

public record JavaRegistryKey<T>(Key registryKey, @Nullable NetworkSerializer<T> networkSerializer, @Nullable NetworkDeserializer<T> networkDeserializer) {
    public int toNetworkId(GeyserSession session, T object) {
        if (this.networkSerializer == null) {
            throw new UnsupportedOperationException("Registry does not hava a network serializer");
        }
        return this.networkSerializer.toNetworkId(session, object);
    }

    public T fromNetworkId(GeyserSession session, int networkId) {
        if (this.networkDeserializer == null) {
            throw new UnsupportedOperationException("Registry does not hava a network deserializer");
        }
        return this.networkDeserializer.fromNetworkId(session, networkId);
    }

    public boolean shouldStoreTags() {
        return this.networkSerializer != null && this.networkDeserializer != null;
    }

    @FunctionalInterface
    public static interface NetworkSerializer<T> {
        public int toNetworkId(GeyserSession var1, T var2);
    }

    @FunctionalInterface
    public static interface NetworkDeserializer<T> {
        public T fromNetworkId(GeyserSession var1, int var2);
    }
}

