/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.httpclient.proxy;

import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.net.Authenticator;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import net.lenni0451.commons.httpclient.proxy.SingleProxyAuthenticator;

public class SingleProxySelector
extends ProxySelector {
    private static final MethodHandle GET_AUTHENTICATOR;
    private final Proxy proxy;
    private final String username;
    private final String password;
    private final ProxySelector defaultProxySelector;
    private final Authenticator defaultAuthenticator;

    public SingleProxySelector(Proxy proxy, String username, String password) {
        this.proxy = proxy;
        this.username = username;
        this.password = password;
        this.defaultProxySelector = ProxySelector.getDefault();
        this.defaultAuthenticator = GET_AUTHENTICATOR.invokeExact();
    }

    public SingleProxySelector set(boolean setProxySelector) {
        if (setProxySelector) {
            ProxySelector.setDefault(this);
        }
        if (this.username != null && this.password != null) {
            Authenticator.setDefault(new SingleProxyAuthenticator(this.username, this.password));
        }
        return this;
    }

    public SingleProxySelector reset(boolean resetProxySelector) {
        if (resetProxySelector) {
            ProxySelector.setDefault(this.defaultProxySelector);
        }
        if (this.username != null && this.password != null) {
            Authenticator.setDefault(this.defaultAuthenticator);
        }
        return this;
    }

    @Override
    public List<Proxy> select(URI uri) {
        return Collections.singletonList(this.proxy);
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
    }

    static {
        MethodHandle getAuthenticator;
        try {
            getAuthenticator = MethodHandles.lookup().findStatic(Authenticator.class, "getDefault", MethodType.methodType(Authenticator.class));
        }
        catch (Throwable t) {
            try {
                Field f = Authenticator.class.getDeclaredField("theAuthenticator");
                f.setAccessible(true);
                getAuthenticator = MethodHandles.lookup().unreflectGetter(f);
            }
            catch (Throwable t2) {
                getAuthenticator = MethodHandles.constant(Authenticator.class, null);
            }
        }
        GET_AUTHENTICATOR = getAuthenticator;
    }
}

