/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.scoreboard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.protocol.bedrock.data.ScoreInfo;
import org.cloudburstmc.protocol.bedrock.data.command.CommandEnumConstraint;
import org.cloudburstmc.protocol.bedrock.packet.SetScorePacket;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.GeyserLogger;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.player.PlayerEntity;
import org.geysermc.geyser.platform.velocity.shaded.it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.geysermc.geyser.scoreboard.Objective;
import org.geysermc.geyser.scoreboard.Team;
import org.geysermc.geyser.scoreboard.UpdateType;
import org.geysermc.geyser.scoreboard.display.slot.BelownameDisplaySlot;
import org.geysermc.geyser.scoreboard.display.slot.DisplaySlot;
import org.geysermc.geyser.scoreboard.display.slot.PlayerlistDisplaySlot;
import org.geysermc.geyser.scoreboard.display.slot.SidebarDisplaySlot;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.mcprotocollib.protocol.data.game.scoreboard.NameTagVisibility;
import org.geysermc.mcprotocollib.protocol.data.game.scoreboard.ScoreboardPosition;
import org.geysermc.mcprotocollib.protocol.data.game.scoreboard.TeamColor;
import org.jetbrains.annotations.Contract;

public final class Scoreboard {
    private static final boolean SHOW_SCOREBOARD_LOGS = Boolean.parseBoolean(System.getProperty("Geyser.ShowScoreboardLogs", "true"));
    private static final boolean ADD_TEAM_SUGGESTIONS = Boolean.parseBoolean(System.getProperty("Geyser.AddTeamSuggestions", String.valueOf(GeyserImpl.getInstance().config().advanced().addTeamSuggestions())));
    private final GeyserSession session;
    private final GeyserLogger logger;
    private final AtomicLong nextId = new AtomicLong(0L);
    private final Map<String, Objective> objectives = new ConcurrentHashMap<String, Objective>();
    private final Map<ScoreboardPosition, DisplaySlot> objectiveSlots = Collections.synchronizedMap(new EnumMap(ScoreboardPosition.class));
    private final List<DisplaySlot> removedSlots = Collections.synchronizedList(new ArrayList());
    private final Map<String, Team> teams = new ConcurrentHashMap<String, Team>();
    private final Map<String, Team> playerToTeam = new Object2ObjectOpenHashMap<String, Team>();
    private final AtomicBoolean updateLockActive = new AtomicBoolean(false);
    private int lastAddScoreCount = 0;
    private int lastRemoveScoreCount = 0;

    public Scoreboard(GeyserSession session) {
        this.session = session;
        this.logger = GeyserImpl.getInstance().getLogger();
    }

    public void removeScoreboard() {
        HashMap<ScoreboardPosition, DisplaySlot> copy = new HashMap<ScoreboardPosition, DisplaySlot>(this.objectiveSlots);
        this.objectiveSlots.clear();
        for (DisplaySlot slot : copy.values()) {
            slot.remove();
        }
    }

    public @Nullable Objective registerNewObjective(String objectiveId) {
        Objective objective = this.objectives.get(objectiveId);
        if (objective != null) {
            if (SHOW_SCOREBOARD_LOGS) {
                this.logger.warning("An objective with the same name '" + objectiveId + "' already exists! Ignoring new objective!");
            }
            return null;
        }
        objective = new Objective(this, objectiveId);
        this.objectives.put(objectiveId, objective);
        return objective;
    }

    public void displayObjective(String objectiveId, ScoreboardPosition slot) {
        if (objectiveId.isEmpty()) {
            DisplaySlot display = this.objectiveSlots.get((Object)slot);
            if (display != null) {
                this.removedSlots.add(display);
                this.objectiveSlots.remove((Object)slot, display);
                Objective objective = display.objective();
                objective.removeDisplaySlot(display);
            }
            return;
        }
        Objective objective = this.objectives.get(objectiveId);
        if (objective == null) {
            return;
        }
        DisplaySlot display = this.objectiveSlots.get((Object)slot);
        if (display != null && display.objective() != objective) {
            this.removedSlots.add(display);
        }
        display = switch (DisplaySlot.slotCategory(slot)) {
            case ScoreboardPosition.SIDEBAR -> new SidebarDisplaySlot(this.session, objective, slot);
            case ScoreboardPosition.BELOW_NAME -> new BelownameDisplaySlot(this.session, objective);
            case ScoreboardPosition.PLAYER_LIST -> new PlayerlistDisplaySlot(this.session, objective);
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)slot));
        };
        this.objectiveSlots.put(slot, display);
        objective.addDisplaySlot(display);
    }

    public void registerNewTeam(String teamName, String[] players, Component name, Component prefix, Component suffix, NameTagVisibility visibility, TeamColor color) {
        Team team = this.teams.get(teamName);
        if (team != null) {
            if (SHOW_SCOREBOARD_LOGS) {
                this.logger.info("Ignoring team %s for %s. It overrides without removing old team.".formatted(teamName, this.session.javaUsername()));
            }
            return;
        }
        team = new Team(this, teamName, players, name, prefix, suffix, visibility, color);
        this.teams.put(teamName, team);
        if (ADD_TEAM_SUGGESTIONS) {
            this.session.addCommandEnum("Geyser_Teams", team.id());
        }
    }

    public void onUpdate() {
        if (this.updateLockActive.getAndSet(true)) {
            return;
        }
        ArrayList<ScoreInfo> addScores = new ArrayList<ScoreInfo>(this.lastAddScoreCount);
        ArrayList<ScoreInfo> removeScores = new ArrayList<ScoreInfo>(this.lastRemoveScoreCount);
        Team playerTeam = this.getTeamFor(this.session.getPlayerEntity().getUsername());
        DisplaySlot correctSidebarSlot = null;
        for (DisplaySlot displaySlot : this.objectiveSlots.values()) {
            if (displaySlot.updateType() == UpdateType.REMOVE || playerTeam == null || playerTeam.color() != displaySlot.teamColor()) continue;
            correctSidebarSlot = displaySlot;
        }
        if (correctSidebarSlot == null) {
            correctSidebarSlot = this.objectiveSlots.get((Object)ScoreboardPosition.SIDEBAR);
        }
        ArrayList<DisplaySlot> actualRemovedSlots = new ArrayList<DisplaySlot>(this.removedSlots);
        for (DisplaySlot slot : actualRemovedSlots) {
            slot.remove();
        }
        this.removedSlots.removeAll(actualRemovedSlots);
        this.handleDisplaySlot(this.objectiveSlots.get((Object)ScoreboardPosition.PLAYER_LIST), addScores, removeScores);
        this.handleDisplaySlot(correctSidebarSlot, addScores, removeScores);
        this.handleDisplaySlot(this.objectiveSlots.get((Object)ScoreboardPosition.BELOW_NAME), addScores, removeScores);
        if (!removeScores.isEmpty()) {
            SetScorePacket setScorePacket = new SetScorePacket();
            setScorePacket.setAction(SetScorePacket.Action.REMOVE);
            setScorePacket.setInfos(removeScores);
            this.session.sendUpstreamPacket(setScorePacket);
        }
        if (!addScores.isEmpty()) {
            SetScorePacket setScorePacket = new SetScorePacket();
            setScorePacket.setAction(SetScorePacket.Action.SET);
            setScorePacket.setInfos(addScores);
            this.session.sendUpstreamPacket(setScorePacket);
        }
        this.lastAddScoreCount = addScores.size();
        this.lastRemoveScoreCount = removeScores.size();
        this.updateLockActive.set(false);
    }

    private void handleDisplaySlot(DisplaySlot slot, List<ScoreInfo> addScores, List<ScoreInfo> removeScores) {
        if (slot != null) {
            slot.render(addScores, removeScores);
        }
    }

    public Objective getObjective(String objectiveName) {
        return this.objectives.get(objectiveName);
    }

    public void removeObjective(Objective objective) {
        this.objectives.remove(objective.getObjectiveName());
        for (DisplaySlot slot : objective.getActiveSlots()) {
            this.objectiveSlots.remove((Object)slot.position(), slot);
            this.removedSlots.add(slot);
        }
    }

    public void resetPlayerScores(String playerNameOrEntityUuid) {
        for (Objective objective : this.objectives.values()) {
            objective.removeScore(playerNameOrEntityUuid);
        }
    }

    public Team getTeam(String teamName) {
        return this.teams.get(teamName);
    }

    public Team getTeamFor(String playerNameOrEntityUuid) {
        return this.playerToTeam.get(playerNameOrEntityUuid);
    }

    public void removeTeam(String teamName) {
        Team remove = this.teams.remove(teamName);
        if (remove == null) {
            return;
        }
        remove.remove();
        this.session.removeCommandEnum("Geyser_Teams", remove.id());
    }

    @Contract(value="-> new")
    public Map<String, Set<CommandEnumConstraint>> getTeamNames() {
        return this.teams.keySet().stream().collect(Collectors.toMap(Function.identity(), o -> EnumSet.noneOf(CommandEnumConstraint.class), (o1, o2) -> o1, LinkedHashMap::new));
    }

    public void playerRegistered(PlayerEntity player) {
        for (DisplaySlot slot : this.objectiveSlots.values()) {
            slot.playerRegistered(player);
        }
    }

    public void playerRemoved(PlayerEntity player) {
        for (DisplaySlot slot : this.objectiveSlots.values()) {
            slot.playerRemoved(player);
        }
    }

    public void entityRegistered(Entity entity) {
        Team team = this.getTeamFor(entity.teamIdentifier());
        if (team != null) {
            team.onEntitySpawn(entity);
        }
    }

    public void entityRemoved(Entity entity) {
        Team team = this.getTeamFor(entity.teamIdentifier());
        if (team != null) {
            team.onEntityRemove(entity);
        }
    }

    public void setTeamFor(Team team, Set<String> entities) {
        for (DisplaySlot slot : this.objectiveSlots.values()) {
            if (!(slot instanceof SidebarDisplaySlot)) continue;
            SidebarDisplaySlot sidebar = (SidebarDisplaySlot)slot;
            sidebar.setTeamFor(team, entities);
        }
    }

    public long nextId() {
        return this.nextId.getAndIncrement();
    }

    public GeyserSession session() {
        return this.session;
    }

    public Map<ScoreboardPosition, DisplaySlot> getObjectiveSlots() {
        return this.objectiveSlots;
    }

    public Map<String, Team> getPlayerToTeam() {
        return this.playerToTeam;
    }
}

