/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.inventory.holder;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.protocol.bedrock.data.definitions.BlockDefinition;
import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerType;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.BlockEntityDataPacket;
import org.cloudburstmc.protocol.bedrock.packet.ContainerClosePacket;
import org.cloudburstmc.protocol.bedrock.packet.ContainerOpenPacket;
import org.cloudburstmc.protocol.bedrock.packet.UpdateBlockPacket;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.inventory.Container;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.LecternContainer;
import org.geysermc.geyser.inventory.holder.InventoryHolder;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.InventoryTranslator;
import org.geysermc.geyser.util.InventoryUtils;

public class BlockInventoryHolder
extends InventoryHolder {
    private final BlockState defaultJavaBlockState;
    private final ContainerType containerType;
    private final Set<Block> validBlocks;

    public BlockInventoryHolder(Block defaultJavaBlock, ContainerType containerType, Block ... validBlocks) {
        this(defaultJavaBlock.defaultBlockState(), containerType, validBlocks);
    }

    public BlockInventoryHolder(BlockState defaultJavaBlockState, ContainerType containerType, Block ... validBlocks) {
        this.defaultJavaBlockState = defaultJavaBlockState;
        this.containerType = containerType;
        if (validBlocks != null) {
            HashSet<Block> validBlocksTemp = new HashSet<Block>(validBlocks.length + 1);
            Collections.addAll(validBlocksTemp, validBlocks);
            validBlocksTemp.add(defaultJavaBlockState.block());
            this.validBlocks = Set.copyOf(validBlocksTemp);
        } else {
            this.validBlocks = Collections.singleton(defaultJavaBlockState.block());
        }
    }

    @Override
    public boolean prepareInventory(InventoryTranslator translator, GeyserSession session, Inventory inventory) {
        Vector3i position;
        if (this.checkInteractionPosition(session)) {
            BlockState state = session.getGeyser().getWorldManager().blockAt(session, session.getLastInteractionBlockPosition());
            if (!((Int2ObjectMap)BlockRegistries.CUSTOM_BLOCK_STATE_OVERRIDES.get()).containsKey(state.javaId()) && this.isValidBlock(state)) {
                inventory.setHolderPosition(session.getLastInteractionBlockPosition());
                ((Container)inventory).setUsingRealBlock(true, state.block());
                this.setCustomName(session, session.getLastInteractionBlockPosition(), inventory, state);
                return true;
            }
        }
        if ((position = InventoryUtils.findAvailableWorldSpace(session)) == null) {
            return false;
        }
        UpdateBlockPacket blockPacket = new UpdateBlockPacket();
        blockPacket.setDataLayer(0);
        blockPacket.setBlockPosition(position);
        blockPacket.setDefinition((BlockDefinition)session.getBlockMappings().getVanillaBedrockBlock(this.defaultJavaBlockState));
        blockPacket.getFlags().addAll(UpdateBlockPacket.FLAG_ALL_PRIORITY);
        session.sendUpstreamPacket((BedrockPacket)blockPacket);
        inventory.setHolderPosition(position);
        this.setCustomName(session, position, inventory, this.defaultJavaBlockState);
        return true;
    }

    protected boolean checkInteractionPosition(GeyserSession session) {
        return session.getLastInteractionPlayerPosition().equals(session.getPlayerEntity().getPosition());
    }

    protected boolean isValidBlock(BlockState blockState) {
        return this.validBlocks.contains(blockState.block());
    }

    protected void setCustomName(GeyserSession session, Vector3i position, Inventory inventory, BlockState javaBlockState) {
        NbtMap tag = NbtMap.builder().putInt("x", position.getX()).putInt("y", position.getY()).putInt("z", position.getZ()).putString("CustomName", inventory.getTitle()).build();
        BlockEntityDataPacket dataPacket = new BlockEntityDataPacket();
        dataPacket.setData(tag);
        dataPacket.setBlockPosition(position);
        session.sendUpstreamPacket((BedrockPacket)dataPacket);
    }

    @Override
    public void openInventory(InventoryTranslator translator, GeyserSession session, Inventory inventory) {
        ContainerOpenPacket containerOpenPacket = new ContainerOpenPacket();
        containerOpenPacket.setId((byte)inventory.getBedrockId());
        containerOpenPacket.setType(this.containerType);
        containerOpenPacket.setBlockPosition(inventory.getHolderPosition());
        containerOpenPacket.setUniqueEntityId(inventory.getHolderId());
        session.sendUpstreamPacket((BedrockPacket)containerOpenPacket);
    }

    @Override
    public void closeInventory(InventoryTranslator translator, GeyserSession session, Inventory inventory, ContainerType type) {
        Vector3i holderPos;
        if (!(inventory instanceof Container)) {
            GeyserImpl.getInstance().getLogger().warning("Tried to close a non-container inventory in a block inventory holder! Please report this error on discord.");
            GeyserImpl.getInstance().getLogger().warning("Current inventory translator: " + translator.getClass().getSimpleName());
            GeyserImpl.getInstance().getLogger().warning("Current inventory: " + inventory.getClass().getSimpleName());
            session.setOpenInventory(null);
            session.setInventoryTranslator(InventoryTranslator.PLAYER_INVENTORY_TRANSLATOR);
            return;
        }
        Container container = (Container)inventory;
        if (container.isUsingRealBlock() && !(container instanceof LecternContainer)) {
            if (type != null) {
                ContainerClosePacket packet = new ContainerClosePacket();
                packet.setId((byte)inventory.getBedrockId());
                packet.setServerInitiated(true);
                packet.setType(type);
                session.sendUpstreamPacket((BedrockPacket)packet);
                return;
            }
            holderPos = inventory.getHolderPosition();
            UpdateBlockPacket blockPacket = new UpdateBlockPacket();
            blockPacket.setDataLayer(0);
            blockPacket.setBlockPosition(holderPos);
            blockPacket.setDefinition((BlockDefinition)session.getBlockMappings().getBedrockAir());
            blockPacket.getFlags().addAll(UpdateBlockPacket.FLAG_ALL_PRIORITY);
            session.sendUpstreamPacket((BedrockPacket)blockPacket);
        }
        holderPos = inventory.getHolderPosition();
        int realBlock = session.getGeyser().getWorldManager().getBlockAt(session, holderPos.getX(), holderPos.getY(), holderPos.getZ());
        UpdateBlockPacket blockPacket = new UpdateBlockPacket();
        blockPacket.setDataLayer(0);
        blockPacket.setBlockPosition(holderPos);
        blockPacket.setDefinition((BlockDefinition)session.getBlockMappings().getBedrockBlock(realBlock));
        blockPacket.getFlags().addAll(UpdateBlockPacket.FLAG_ALL_PRIORITY);
        session.sendUpstreamPacket((BedrockPacket)blockPacket);
    }
}

