/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.bedrock.entity.player.input;

import java.util.Set;
import org.cloudburstmc.math.GenericMath;
import org.cloudburstmc.math.vector.Vector2f;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.protocol.bedrock.data.LevelEvent;
import org.cloudburstmc.protocol.bedrock.data.LevelEventType;
import org.cloudburstmc.protocol.bedrock.data.PlayerActionType;
import org.cloudburstmc.protocol.bedrock.data.PlayerAuthInputData;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.cloudburstmc.protocol.bedrock.data.inventory.transaction.ItemUseTransaction;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.LevelEventPacket;
import org.cloudburstmc.protocol.bedrock.packet.PlayerActionPacket;
import org.cloudburstmc.protocol.bedrock.packet.PlayerAuthInputPacket;
import org.geysermc.geyser.entity.EntityDefinitions;
import org.geysermc.geyser.entity.type.BoatEntity;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.ItemFrameEntity;
import org.geysermc.geyser.entity.type.living.animal.horse.AbstractHorseEntity;
import org.geysermc.geyser.entity.type.living.animal.horse.LlamaEntity;
import org.geysermc.geyser.entity.type.player.SessionPlayerEntity;
import org.geysermc.geyser.entity.vehicle.ClientVehicle;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.translator.protocol.bedrock.BedrockInventoryTransactionTranslator;
import org.geysermc.geyser.translator.protocol.bedrock.entity.player.input.BedrockBlockActions;
import org.geysermc.geyser.translator.protocol.bedrock.entity.player.input.BedrockMovePlayer;
import org.geysermc.geyser.util.CooldownUtils;
import org.geysermc.mcprotocollib.network.packet.Packet;
import org.geysermc.mcprotocollib.protocol.data.game.entity.object.Direction;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.GameMode;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.InteractAction;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.PlayerAction;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.PlayerState;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.level.ServerboundMoveVehiclePacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundInteractPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundPlayerAbilitiesPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundPlayerActionPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundPlayerCommandPacket;

@Translator(packet=PlayerAuthInputPacket.class)
public final class BedrockPlayerAuthInputTranslator
extends PacketTranslator<PlayerAuthInputPacket> {
    @Override
    public void translate(GeyserSession session, PlayerAuthInputPacket packet) {
        SessionPlayerEntity entity = session.getPlayerEntity();
        boolean wasJumping = session.getInputCache().wasJumping();
        session.getInputCache().processInputs(packet);
        BedrockMovePlayer.translate(session, packet);
        BedrockPlayerAuthInputTranslator.processVehicleInput(session, packet, wasJumping);
        Set inputData = packet.getInputData();
        for (PlayerAuthInputData input : inputData) {
            switch (input) {
                case PERFORM_ITEM_INTERACTION: {
                    BedrockPlayerAuthInputTranslator.processItemUseTransaction(session, packet.getItemUseTransaction());
                    break;
                }
                case PERFORM_BLOCK_ACTIONS: {
                    BedrockBlockActions.translate(session, packet.getPlayerActions());
                    break;
                }
                case START_SNEAKING: {
                    ServerboundPlayerCommandPacket startSneakPacket = new ServerboundPlayerCommandPacket(entity.getEntityId(), PlayerState.START_SNEAKING);
                    session.sendDownstreamGamePacket((Packet)startSneakPacket);
                    session.startSneaking();
                    break;
                }
                case STOP_SNEAKING: {
                    ServerboundPlayerCommandPacket stopSneakPacket = new ServerboundPlayerCommandPacket(entity.getEntityId(), PlayerState.STOP_SNEAKING);
                    session.sendDownstreamGamePacket((Packet)stopSneakPacket);
                    session.stopSneaking();
                    break;
                }
                case START_SPRINTING: {
                    if (entity.getFlag(EntityFlag.SWIMMING)) break;
                    ServerboundPlayerCommandPacket startSprintPacket = new ServerboundPlayerCommandPacket(entity.getEntityId(), PlayerState.START_SPRINTING);
                    session.sendDownstreamGamePacket((Packet)startSprintPacket);
                    session.setSprinting(true);
                    break;
                }
                case STOP_SPRINTING: {
                    if (!entity.getFlag(EntityFlag.SWIMMING)) {
                        ServerboundPlayerCommandPacket stopSprintPacket = new ServerboundPlayerCommandPacket(entity.getEntityId(), PlayerState.STOP_SPRINTING);
                        session.sendDownstreamGamePacket((Packet)stopSprintPacket);
                    }
                    session.setSprinting(false);
                    break;
                }
                case START_SWIMMING: {
                    session.setSwimming(true);
                    break;
                }
                case STOP_SWIMMING: {
                    session.setSwimming(false);
                    break;
                }
                case START_CRAWLING: {
                    session.setCrawling(true);
                    break;
                }
                case STOP_CRAWLING: {
                    session.setCrawling(false);
                    break;
                }
                case START_FLYING: {
                    if (session.isCanFly()) {
                        if (session.getGameMode() == GameMode.SPECTATOR) {
                            session.sendAdventureSettings();
                            break;
                        }
                        if (session.getPlayerEntity().getFlag(EntityFlag.SWIMMING) && session.getCollisionManager().isPlayerInWater()) {
                            session.sendAdventureSettings();
                            break;
                        }
                        session.setFlying(true);
                        session.sendDownstreamGamePacket((Packet)new ServerboundPlayerAbilitiesPacket(true));
                        break;
                    }
                    session.sendAdventureSettings();
                    PlayerActionPacket stopFlyingPacket = new PlayerActionPacket();
                    stopFlyingPacket.setRuntimeEntityId(session.getPlayerEntity().getGeyserId());
                    stopFlyingPacket.setAction(PlayerActionType.STOP_FLYING);
                    stopFlyingPacket.setBlockPosition(Vector3i.ZERO);
                    stopFlyingPacket.setResultPosition(Vector3i.ZERO);
                    stopFlyingPacket.setFace(0);
                    session.sendUpstreamPacket((BedrockPacket)stopFlyingPacket);
                    break;
                }
                case STOP_FLYING: {
                    session.setFlying(false);
                    session.sendDownstreamGamePacket((Packet)new ServerboundPlayerAbilitiesPacket(false));
                    break;
                }
                case START_GLIDING: {
                    ServerboundPlayerAbilitiesPacket playerAbilitiesPacket = new ServerboundPlayerAbilitiesPacket(false);
                    session.sendDownstreamGamePacket((Packet)playerAbilitiesPacket);
                    BedrockPlayerAuthInputTranslator.sendPlayerGlideToggle(session, entity);
                    break;
                }
                case STOP_GLIDING: {
                    BedrockPlayerAuthInputTranslator.sendPlayerGlideToggle(session, entity);
                    break;
                }
                case MISSED_SWING: {
                    CooldownUtils.sendCooldown(session);
                }
            }
        }
        if (entity.getVehicle() instanceof BoatEntity) {
            boolean up = inputData.contains(PlayerAuthInputData.UP);
            session.setSteeringLeft(up || inputData.contains(PlayerAuthInputData.PADDLE_RIGHT));
            session.setSteeringRight(up || inputData.contains(PlayerAuthInputData.PADDLE_LEFT));
        }
    }

    private static void sendPlayerGlideToggle(GeyserSession session, Entity entity) {
        ServerboundPlayerCommandPacket glidePacket = new ServerboundPlayerCommandPacket(entity.getEntityId(), PlayerState.START_ELYTRA_FLYING);
        session.sendDownstreamGamePacket((Packet)glidePacket);
    }

    private static void processItemUseTransaction(GeyserSession session, ItemUseTransaction transaction) {
        if (transaction.getActionType() == 2) {
            int blockState = session.getGameMode() == GameMode.CREATIVE ? session.getGeyser().getWorldManager().getBlockAt(session, transaction.getBlockPosition()) : session.getBreakingBlock();
            session.setLastBlockPlaced(null);
            session.setLastBlockPlacePosition(null);
            if (!session.getWorldBorder().isInsideBorderBoundaries()) {
                BedrockInventoryTransactionTranslator.restoreCorrectBlock(session, transaction.getBlockPosition());
                return;
            }
            Vector3f playerPosition = session.getPlayerEntity().getPosition();
            if (!BedrockInventoryTransactionTranslator.canInteractWithBlock(session, playerPosition = playerPosition.down(EntityDefinitions.PLAYER.offset() - session.getEyeHeight()), transaction.getBlockPosition())) {
                BedrockInventoryTransactionTranslator.restoreCorrectBlock(session, transaction.getBlockPosition());
                return;
            }
            int sequence = session.getWorldCache().nextPredictionSequence();
            session.getWorldCache().markPositionInSequence(transaction.getBlockPosition());
            if (blockState == -1) {
                blockState = 0;
            }
            LevelEventPacket blockBreakPacket = new LevelEventPacket();
            blockBreakPacket.setType((LevelEventType)LevelEvent.PARTICLE_DESTROY_BLOCK);
            blockBreakPacket.setPosition(transaction.getBlockPosition().toFloat());
            blockBreakPacket.setData(session.getBlockMappings().getBedrockBlockId(blockState));
            session.sendUpstreamPacket((BedrockPacket)blockBreakPacket);
            session.setBreakingBlock(-1);
            ItemFrameEntity itemFrameEntity = ItemFrameEntity.getItemFrameEntity(session, transaction.getBlockPosition());
            if (itemFrameEntity != null) {
                ServerboundInteractPacket attackPacket = new ServerboundInteractPacket(itemFrameEntity.getEntityId(), InteractAction.ATTACK, session.isSneaking());
                session.sendDownstreamGamePacket((Packet)attackPacket);
                return;
            }
            PlayerAction action = session.getGameMode() == GameMode.CREATIVE ? PlayerAction.START_DIGGING : PlayerAction.FINISH_DIGGING;
            ServerboundPlayerActionPacket breakPacket = new ServerboundPlayerActionPacket(action, transaction.getBlockPosition(), Direction.VALUES[transaction.getBlockFace()], sequence);
            session.sendDownstreamGamePacket((Packet)breakPacket);
        } else {
            session.getGeyser().getLogger().error("Unhandled item use transaction type!");
            if (session.getGeyser().getLogger().isDebug()) {
                session.getGeyser().getLogger().debug(transaction);
            }
        }
    }

    private static void processVehicleInput(GeyserSession session, PlayerAuthInputPacket packet, boolean wasJumping) {
        Entity vehicle = session.getPlayerEntity().getVehicle();
        if (vehicle == null) {
            return;
        }
        if (vehicle instanceof ClientVehicle) {
            session.getPlayerEntity().setVehicleInput(packet.getMotion());
        }
        boolean sendMovement = false;
        if (vehicle instanceof AbstractHorseEntity && !(vehicle instanceof LlamaEntity)) {
            sendMovement = !(vehicle instanceof ClientVehicle);
        } else if (vehicle instanceof BoatEntity) {
            if (vehicle.getPassengers().size() == 1) {
                sendMovement = true;
            } else if (session.getPlayerEntity().isRidingInFront()) {
                sendMovement = true;
            }
        }
        if (vehicle instanceof AbstractHorseEntity && !vehicle.getFlag(EntityFlag.HAS_DASH_COOLDOWN)) {
            int currentJumpingTicks = session.getInputCache().getJumpingTicks();
            if (currentJumpingTicks < 0) {
                session.getInputCache().setJumpingTicks(++currentJumpingTicks);
                if (currentJumpingTicks == 0) {
                    session.getInputCache().setJumpScale(0.0f);
                }
            }
            boolean holdingJump = packet.getInputData().contains(PlayerAuthInputData.JUMPING);
            if (wasJumping && !holdingJump) {
                int finalVehicleJumpStrength = GenericMath.floor((float)(session.getInputCache().getJumpScale() * 100.0f));
                session.sendDownstreamGamePacket((Packet)new ServerboundPlayerCommandPacket(session.getPlayerEntity().getEntityId(), PlayerState.START_HORSE_JUMP, finalVehicleJumpStrength));
                session.getInputCache().setJumpingTicks(-10);
                session.getPlayerEntity().setVehicleJumpStrength(finalVehicleJumpStrength);
            } else if (!wasJumping && holdingJump) {
                session.getInputCache().setJumpingTicks(0);
                session.getInputCache().setJumpScale(0.0f);
            } else if (holdingJump) {
                session.getInputCache().setJumpingTicks(++currentJumpingTicks);
                if (currentJumpingTicks < 10) {
                    session.getInputCache().setJumpScale((float)session.getInputCache().getJumpingTicks() * 0.1f);
                } else {
                    session.getInputCache().setJumpScale(0.8f + 2.0f / (float)(currentJumpingTicks - 9) * 0.1f);
                }
            }
        } else {
            session.getInputCache().setJumpScale(0.0f);
        }
        if (sendMovement) {
            vehicle.setOnGround((double)Math.abs(packet.getDelta().getY()) < 0.1);
            Vector3f vehiclePosition = packet.getPosition();
            Vector2f vehicleRotation = packet.getVehicleRotation();
            if (vehicleRotation == null) {
                return;
            }
            if (session.getWorldBorder().isPassingIntoBorderBoundaries(vehiclePosition, false)) {
                Vector3f position = vehicle.getPosition();
                if (vehicle instanceof BoatEntity) {
                    BoatEntity boat = (BoatEntity)vehicle;
                    boat.moveAbsoluteWithoutAdjustments(position, vehicle.getYaw(), vehicle.isOnGround(), true);
                } else {
                    vehicle.moveAbsolute(position, vehicle.getYaw(), vehicle.getPitch(), vehicle.getHeadYaw(), vehicle.isOnGround(), true);
                }
                return;
            }
            if (vehicle instanceof BoatEntity && !vehicle.isOnGround()) {
                vehiclePosition = vehiclePosition.down(vehicle.getDefinition().offset());
            }
            vehicle.setPosition(vehiclePosition);
            ServerboundMoveVehiclePacket moveVehiclePacket = new ServerboundMoveVehiclePacket(vehiclePosition.toDouble(), vehicleRotation.getY() - 90.0f, vehiclePosition.getX(), vehicle.isOnGround());
            session.sendDownstreamGamePacket((Packet)moveVehiclePacket);
        }
    }
}

