/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.command;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.kyori.adventure.key.Key;
import org.checkerframework.checker.nullness.qual.NonNull;

public enum SuggestionType {
    ASK_SERVER,
    AVAILABLE_SOUNDS,
    SUMMONABLE_ENTITIES;

    private final Key resourceLocation;
    private static final Map<Key, SuggestionType> VALUES;

    private SuggestionType() {
        String lowerCase = this.name().toLowerCase(Locale.ROOT);
        this.resourceLocation = Key.key(lowerCase);
    }

    public Key getResourceLocation() {
        return this.resourceLocation;
    }

    public static @NonNull SuggestionType from(Key resourceLocation) {
        return VALUES.getOrDefault(resourceLocation, ASK_SERVER);
    }

    static {
        VALUES = new HashMap<Key, SuggestionType>();
        for (SuggestionType suggestionType : SuggestionType.values()) {
            VALUES.put(suggestionType.resourceLocation, suggestionType);
        }
    }
}

