/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.geysermc.geyser.inventory.BedrockContainerSlot;
import org.geysermc.geyser.inventory.Container;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.holder.BlockInventoryHolder;
import org.geysermc.geyser.inventory.updater.ContainerInventoryUpdater;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.level.block.property.Properties;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.level.physics.Direction;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.ContainerSlotType;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.ContainerType;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.BlockEntityDataPacket;
import org.geysermc.geyser.translator.inventory.AbstractBlockInventoryTranslator;
import org.geysermc.geyser.translator.level.block.entity.BlockEntityTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.BlockEntityType;

public class ShulkerInventoryTranslator
extends AbstractBlockInventoryTranslator<Container> {
    public ShulkerInventoryTranslator() {
        super(27, new BlockInventoryHolder(Blocks.SHULKER_BOX.defaultBlockState().withValue(Properties.FACING, Direction.NORTH), ContainerType.CONTAINER, new Block[0]){
            private final BlockEntityTranslator shulkerBoxTranslator = (BlockEntityTranslator)Registries.BLOCK_ENTITIES.get(BlockEntityType.SHULKER_BOX);

            @Override
            protected boolean isValidBlock(BlockState blockState) {
                return blockState.block().javaIdentifier().value().contains("shulker_box");
            }

            @Override
            protected void setCustomName(GeyserSession session, Vector3i position, Inventory inventory, BlockState javaBlockState) {
                NbtMapBuilder tag = NbtMap.builder().putInt("x", position.getX()).putInt("y", position.getY()).putInt("z", position.getZ()).putString("CustomName", inventory.getTitle());
                this.shulkerBoxTranslator.translateTag(session, tag, null, javaBlockState);
                BlockEntityDataPacket dataPacket = new BlockEntityDataPacket();
                dataPacket.setData(tag.build());
                dataPacket.setBlockPosition(position);
                session.sendUpstreamPacket(dataPacket);
            }
        }, ContainerInventoryUpdater.INSTANCE);
    }

    @Override
    public BedrockContainerSlot javaSlotToBedrockContainer(int javaSlot, Container container) {
        if (javaSlot < this.size) {
            return new BedrockContainerSlot(ContainerSlotType.SHULKER_BOX, javaSlot);
        }
        return super.javaSlotToBedrockContainer(javaSlot, container);
    }

    @Override
    public @Nullable ContainerType closeContainerType(Container container) {
        return ContainerType.CONTAINER;
    }
}

