/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.level.border;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ClientboundSetBorderCenterPacket
implements MinecraftPacket {
    private final double newCenterX;
    private final double newCenterZ;

    public ClientboundSetBorderCenterPacket(ByteBuf in) {
        this.newCenterX = in.readDouble();
        this.newCenterZ = in.readDouble();
    }

    @Override
    public void serialize(ByteBuf out) {
        out.writeDouble(this.newCenterX);
        out.writeDouble(this.newCenterZ);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public double getNewCenterX() {
        return this.newCenterX;
    }

    public double getNewCenterZ() {
        return this.newCenterZ;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSetBorderCenterPacket)) {
            return false;
        }
        ClientboundSetBorderCenterPacket other = (ClientboundSetBorderCenterPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getNewCenterX(), other.getNewCenterX()) != 0) {
            return false;
        }
        return Double.compare(this.getNewCenterZ(), other.getNewCenterZ()) == 0;
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundSetBorderCenterPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $newCenterX = Double.doubleToLongBits(this.getNewCenterX());
        result = result * 59 + (int)($newCenterX >>> 32 ^ $newCenterX);
        long $newCenterZ = Double.doubleToLongBits(this.getNewCenterZ());
        result = result * 59 + (int)($newCenterZ >>> 32 ^ $newCenterZ);
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundSetBorderCenterPacket(newCenterX=" + this.getNewCenterX() + ", newCenterZ=" + this.getNewCenterZ() + ")";
    }

    public @NonNull ClientboundSetBorderCenterPacket withNewCenterX(double newCenterX) {
        return this.newCenterX == newCenterX ? this : new ClientboundSetBorderCenterPacket(newCenterX, this.newCenterZ);
    }

    public @NonNull ClientboundSetBorderCenterPacket withNewCenterZ(double newCenterZ) {
        return this.newCenterZ == newCenterZ ? this : new ClientboundSetBorderCenterPacket(this.newCenterX, newCenterZ);
    }

    public ClientboundSetBorderCenterPacket(double newCenterX, double newCenterZ) {
        this.newCenterX = newCenterX;
        this.newCenterZ = newCenterZ;
    }
}

