/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.configuration;

import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiFunction;
import org.geysermc.geyser.GeyserBootstrap;
import org.geysermc.geyser.configuration.GeyserConfig;
import org.geysermc.geyser.configuration.GeyserRemoteConfig;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.NodePath;
import org.spongepowered.configurate.transformation.ConfigurationTransformation;
import org.spongepowered.configurate.transformation.TransformAction;

public class ConfigMigrations {
    public static final BiFunction<Class<? extends GeyserConfig>, GeyserBootstrap, ConfigurationTransformation.Versioned> TRANSFORMER = (configClass, bootstrap) -> ConfigurationTransformation.versionedBuilder().versionKey(new Object[]{"config-version"}).addVersion(5, ConfigurationTransformation.builder().addAction(NodePath.path((Object[])new Object[]{"remote"}), TransformAction.rename((Object)"java")).addAction(NodePath.path((Object[])new Object[]{"remote", "address"}), (path, value) -> {
        if ("auto".equals(value.getString())) {
            value.set((Object)"127.0.0.1");
        }
        return null;
    }).addAction(NodePath.path((Object[])new Object[]{"bedrock", "motd1"}), ConfigMigrations.renameAndMove("motd", "primary-motd")).addAction(NodePath.path((Object[])new Object[]{"bedrock", "motd2"}), ConfigMigrations.renameAndMove("motd", "secondary-motd")).addAction(NodePath.path((Object[])new Object[]{"passthrough-motd"}), ConfigMigrations.moveTo("motd")).addAction(NodePath.path((Object[])new Object[]{"passthrough-player-counts"}), ConfigMigrations.moveTo("motd")).addAction(NodePath.path((Object[])new Object[]{"ping-passthrough-interval"}), ConfigMigrations.moveTo("motd")).addAction(NodePath.path((Object[])new Object[]{"max-players"}), ConfigMigrations.moveTo("motd")).addAction(NodePath.path((Object[])new Object[]{"legacy-ping-passthrough"}), configClass == GeyserRemoteConfig.class ? TransformAction.remove() : (path, value) -> {
        value.set((Object)(!value.getBoolean() ? 1 : 0));
        return new Object[]{"motd", "integrated-ping-passthrough"};
    }).addAction(NodePath.path((Object[])new Object[]{"command-suggestions"}), ConfigMigrations.moveTo("gameplay")).addAction(NodePath.path((Object[])new Object[]{"forward-player-ping"}), ConfigMigrations.moveTo("gameplay")).addAction(NodePath.path((Object[])new Object[]{"show-cooldown"}), (path, value) -> {
        String s = value.getString();
        if (s != null) {
            switch (s) {
                case "true": {
                    value.set((Object)"title");
                    break;
                }
                case "false": {
                    value.set((Object)"disabled");
                }
            }
        }
        return new Object[]{"gameplay", "show-cooldown"};
    }).addAction(NodePath.path((Object[])new Object[]{"bedrock", "server-name"}), ConfigMigrations.moveTo("gameplay")).addAction(NodePath.path((Object[])new Object[]{"show-coordinates"}), ConfigMigrations.moveTo("gameplay")).addAction(NodePath.path((Object[])new Object[]{"disable-bedrock-scaffolding"}), ConfigMigrations.moveTo("gameplay")).addAction(NodePath.path((Object[])new Object[]{"custom-skull-render-distance"}), ConfigMigrations.moveTo("gameplay")).addAction(NodePath.path((Object[])new Object[]{"force-resource-packs"}), ConfigMigrations.moveTo("gameplay")).addAction(NodePath.path((Object[])new Object[]{"xbox-achievements-enabled"}), ConfigMigrations.moveTo("gameplay")).addAction(NodePath.path((Object[])new Object[]{"unusable-space-block"}), ConfigMigrations.moveTo("gameplay")).addAction(NodePath.path((Object[])new Object[]{"unusable-space-block"}), ConfigMigrations.moveTo("gameplay")).addAction(NodePath.path((Object[])new Object[]{"add-non-bedrock-items"}), ConfigMigrations.renameAndMove("gameplay", "enable-custom-content")).addAction(NodePath.path((Object[])new Object[]{"above-bedrock-nether-building"}), ConfigMigrations.renameAndMove("gameplay", "nether-roof-workaround")).addAction(NodePath.path((Object[])new Object[]{"xbox-achievements-enabled"}), ConfigMigrations.moveTo("gameplay")).addAction(NodePath.path((Object[])new Object[]{"max-visible-custom-skulls"}), (path, value) -> {
        ConfigurationNode allowCustomSkulls;
        ConfigurationNode parent = value.parent();
        if (parent != null && parent.isMap() && (allowCustomSkulls = (ConfigurationNode)parent.childrenMap().get("allow-custom-skulls")) != null && !allowCustomSkulls.getBoolean()) {
            value.set((Object)0);
        }
        return new Object[]{"gameplay", "max-visible-custom-skulls"};
    }).addAction(NodePath.path((Object[])new Object[]{"emote-offhand-workaround"}), (path, value) -> {
        String previous = value.getString();
        if (!Objects.equals(previous, "disabled") && bootstrap != null) {
            bootstrap.getGeyserLogger().warning("The emote-offhand-workaround option has been removed from Geyser. If you still wish to have this functionality, use this Geyser extension: https://github.com/GeyserMC/EmoteOffhandExtension/");
        }
        if (Objects.equals(previous, "no-emotes")) {
            value.set((Object)false);
            return new Object[]{"gameplay", "show-emotes"};
        }
        return null;
    }).addAction(NodePath.path((Object[])new Object[]{"allow-third-party-capes"}), (node, value) -> {
        if (bootstrap != null) {
            bootstrap.getGeyserLogger().warning("Third-party ears/capes have been removed from Geyser. If you still wish to have this functionality, use this Geyser extension: https://github.com/GeyserMC/ThirdPartyCosmetics");
        }
        return null;
    }).addAction(NodePath.path((Object[])new Object[]{"allow-third-party-ears"}), (node, value) -> {
        if (bootstrap != null) {
            bootstrap.getGeyserLogger().warning("Third-party ears/capes have been removed from Geyser. If you still wish to have this functionality, use this Geyser extension: https://github.com/GeyserMC/ThirdPartyCosmetics");
        }
        return null;
    }).addAction(NodePath.path((Object[])new Object[]{"cache-images"}), ConfigMigrations.moveTo("advanced")).addAction(NodePath.path((Object[])new Object[]{"scoreboard-packet-threshold"}), ConfigMigrations.moveTo("advanced")).addAction(NodePath.path((Object[])new Object[]{"add-team-suggestions"}), ConfigMigrations.moveTo("advanced")).addAction(NodePath.path((Object[])new Object[]{"floodgate-key-file"}), (path, value) -> {
        if ("public-key.pem".equals(value.getString())) {
            value.set((Object)"key.pem");
        }
        return new Object[]{"advanced", "floodgate-key-file"};
    }).addAction(NodePath.path((Object[])new Object[]{"bedrock", "broadcast-port"}), ConfigMigrations.moveTo("advanced", "bedrock")).addAction(NodePath.path((Object[])new Object[]{"bedrock", "compression-level"}), ConfigMigrations.moveTo("advanced", "bedrock")).addAction(NodePath.path((Object[])new Object[]{"bedrock", "enable-proxy-protocol"}), ConfigMigrations.renameAndMove("advanced", "bedrock", "use-haproxy-protocol")).addAction(NodePath.path((Object[])new Object[]{"bedrock", "proxy-protocol-whitelisted-ips"}), ConfigMigrations.renameAndMove("advanced", "bedrock", "haproxy-protocol-whitelisted-ips")).addAction(NodePath.path((Object[])new Object[]{"mtu"}), ConfigMigrations.moveTo("advanced", "bedrock")).addAction(NodePath.path((Object[])new Object[]{"remote", "use-proxy-protocol"}), ConfigMigrations.renameAndMove("advanced", "java", "use-haproxy-protocol")).addAction(NodePath.path((Object[])new Object[]{"disable-compression"}), ConfigMigrations.moveTo("advanced", "java")).addAction(NodePath.path((Object[])new Object[]{"use-direct-connection"}), ConfigMigrations.moveTo("advanced", "java")).addAction(NodePath.path((Object[])new Object[]{"default-locale"}), (path, value) -> {
        if (value.getString() == null) {
            value.set((Object)"system");
        }
        return null;
    }).addAction(NodePath.path((Object[])new Object[]{"metrics", "uuid"}), (path, value) -> {
        if ("generateduuid".equals(value.getString())) {
            value.set((Object)UUID.randomUUID());
        }
        return new Object[]{"metrics-uuid"};
    }).addAction(NodePath.path((Object[])new Object[]{"metrics", "enabled"}), (path, value) -> new Object[]{"enable-metrics"}).build()).build();

    static TransformAction renameAndMove(String ... newPath) {
        return (path, value) -> Arrays.stream(newPath).toArray();
    }

    static TransformAction moveTo(String ... newPath) {
        return (path, value) -> {
            Object[] arr = path.array();
            if (arr.length == 0) {
                throw new ConfigurateException(value, "The root node cannot be renamed!");
            }
            Object[] result = new Object[newPath.length + 1];
            System.arraycopy(newPath, 0, result, 0, newPath.length);
            result[newPath.length] = arr[arr.length - 1];
            return result;
        };
    }
}

