/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util;

import java.util.List;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.PlayerListPacket;

public class PlayerListUtils {
    static final int MAX_PLAYER_LIST_PACKET_ENTRIES = 1000;

    public static void batchSendPlayerList(GeyserSession session, List<PlayerListPacket.Entry> entries, PlayerListPacket.Action action) {
        if (entries.size() > 1000) {
            int batches = entries.size() / 1000 + (entries.size() % 1000 > 0 ? 1 : 0);
            for (int i = 0; i < batches; ++i) {
                int start = i * 1000;
                int end = Math.min(start + 1000, entries.size());
                PlayerListPacket packet = new PlayerListPacket();
                packet.setAction(action);
                packet.getEntries().addAll(entries.subList(start, end));
                session.sendUpstreamPacket(packet);
            }
        } else {
            PlayerListPacket packet = new PlayerListPacket();
            packet.setAction(action);
            packet.getEntries().addAll(entries);
            session.sendUpstreamPacket(packet);
        }
    }
}

