/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.level.block;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.api.block.custom.CustomBlockData;
import org.geysermc.geyser.api.block.custom.CustomBlockState;
import org.geysermc.geyser.api.block.custom.property.CustomBlockProperty;

public final class GeyserCustomBlockState
implements CustomBlockState {
    private final CustomBlockData block;
    private final Map<String, Object> properties;

    @Override
    public @NonNull CustomBlockData block() {
        return this.block;
    }

    @Override
    public @NonNull String name() {
        return this.block.name();
    }

    @Override
    public <T> @NonNull T property(@NonNull String propertyName) {
        return (T)this.properties.get(propertyName);
    }

    @Override
    public @NonNull Map<String, Object> properties() {
        return this.properties;
    }

    public GeyserCustomBlockState(CustomBlockData block, Map<String, Object> properties) {
        this.block = block;
        this.properties = properties;
    }

    public CustomBlockData getBlock() {
        return this.block;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeyserCustomBlockState)) {
            return false;
        }
        GeyserCustomBlockState other = (GeyserCustomBlockState)o;
        CustomBlockData this$block = this.getBlock();
        CustomBlockData other$block = other.getBlock();
        if (this$block == null ? other$block != null : !this$block.equals(other$block)) {
            return false;
        }
        Map<String, Object> this$properties = this.getProperties();
        Map<String, Object> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CustomBlockData $block = this.getBlock();
        result = result * 59 + ($block == null ? 43 : $block.hashCode());
        Map<String, Object> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "GeyserCustomBlockState(block=" + String.valueOf(this.getBlock()) + ", properties=" + String.valueOf(this.getProperties()) + ")";
    }

    public static class Builder
    implements CustomBlockState.Builder {
        private final CustomBlockData blockData;
        private final Object2ObjectMap<String, Object> properties = new Object2ObjectOpenHashMap<String, Object>();

        @Override
        public Builder booleanProperty(@NonNull String propertyName, boolean value) {
            this.properties.put(propertyName, value ? (byte)1 : 0);
            return this;
        }

        @Override
        public Builder intProperty(@NonNull String propertyName, int value) {
            this.properties.put(propertyName, value);
            return this;
        }

        @Override
        public Builder stringProperty(@NonNull String propertyName, @NonNull String value) {
            this.properties.put(propertyName, value);
            return this;
        }

        @Override
        public CustomBlockState build() {
            for (String propertyName : this.blockData.properties().keySet()) {
                if (this.properties.containsKey(propertyName)) continue;
                throw new IllegalArgumentException("Missing property: " + propertyName);
            }
            for (Map.Entry entry : this.properties.entrySet()) {
                String propertyName = (String)entry.getKey();
                Object propertyValue = entry.getValue();
                CustomBlockProperty<?> property = this.blockData.properties().get(propertyName);
                if (property == null) {
                    throw new IllegalArgumentException("Unknown property: " + propertyName);
                }
                if (property.values().contains(propertyValue)) continue;
                throw new IllegalArgumentException("Invalid value: " + String.valueOf(propertyValue) + " for property: " + propertyName);
            }
            return new GeyserCustomBlockState(this.blockData, Object2ObjectMaps.unmodifiable(this.properties));
        }

        public Builder(CustomBlockData blockData) {
            this.blockData = blockData;
        }
    }
}

