/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.cache.registry;

import java.util.List;
import java.util.Optional;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.key.Key;
import org.geysermc.geyser.session.cache.registry.RegistryEntryData;

public interface JavaRegistry<T> {
    default public @Nullable T byId(@NonNegative int id) {
        return this.entryById(id).map(RegistryEntryData::data).orElse(null);
    }

    default public Optional<RegistryEntryData<T>> entryById(@NonNegative int id) {
        List<RegistryEntryData<T>> entries = this.entries();
        if (id < 0 || id >= entries.size()) {
            return Optional.empty();
        }
        return Optional.of(entries.get(id));
    }

    default public @Nullable T byKey(Key key) {
        return this.entryByKey(key).map(RegistryEntryData::data).orElse(null);
    }

    default public Optional<RegistryEntryData<T>> entryByKey(Key key) {
        List<RegistryEntryData<T>> entries = this.entries();
        for (RegistryEntryData<T> entry : entries) {
            if (!entry.key().equals(key)) continue;
            return Optional.of(entry);
        }
        return Optional.empty();
    }

    default public int byValue(T value) {
        return this.entryByValue(value).map(RegistryEntryData::id).orElse(-1);
    }

    default public Optional<RegistryEntryData<T>> entryByValue(T value) {
        List<RegistryEntryData<T>> entries = this.entries();
        for (RegistryEntryData<T> entry : entries) {
            if (!entry.data().equals(value)) continue;
            return Optional.of(entry);
        }
        return Optional.empty();
    }

    default public List<Key> keys() {
        return this.entries().stream().map(RegistryEntryData::key).toList();
    }

    default public List<T> values() {
        return this.entries().stream().map(RegistryEntryData::data).toList();
    }

    default public int size() {
        return this.entries().size();
    }

    public List<RegistryEntryData<T>> entries();
}

