/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type;

import java.util.UUID;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.ByteEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.type.EntityType;

public class AbstractArrowEntity
extends Entity {
    public AbstractArrowEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
        this.setFlag(EntityFlag.BRIBED, definition.entityType() == EntityType.SPECTRAL_ARROW);
        this.setMotion(motion);
    }

    public void setArrowFlags(ByteEntityMetadata entityMetadata) {
        byte data = entityMetadata.getPrimitiveValue();
        this.setFlag(EntityFlag.CRITICAL, (data & 1) == 1);
    }

    @Override
    public void setYaw(float yaw) {
    }

    @Override
    public void setPitch(float pitch) {
    }

    @Override
    public void setHeadYaw(float headYaw) {
    }

    @Override
    public void setMotion(Vector3f motion) {
        super.setMotion(motion);
        double horizontalSpeed = Math.sqrt(motion.getX() * motion.getX() + motion.getZ() * motion.getZ());
        this.setYaw((float)Math.toDegrees(Math.atan2(motion.getX(), motion.getZ())));
        this.setPitch((float)Math.toDegrees(Math.atan2(motion.getY(), horizontalSpeed)));
        this.setHeadYaw(this.getYaw());
    }
}

