/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.animal;

import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.living.animal.AnimalEntity;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.type.DyeItem;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.tags.ItemTag;
import org.geysermc.geyser.session.cache.tags.Tag;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.geyser.util.InteractiveTag;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.ByteEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;

public class SheepEntity
extends AnimalEntity {
    private int color;

    public SheepEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    public void setSheepFlags(ByteEntityMetadata entityMetadata) {
        byte xd = entityMetadata.getPrimitiveValue();
        this.setFlag(EntityFlag.SHEARED, (xd & 0x10) == 16);
        this.color = xd & 0xF;
        this.dirtyMetadata.put(EntityDataTypes.COLOR, (byte)this.color);
    }

    @Override
    protected @Nullable Tag<Item> getFoodTag() {
        return ItemTag.SHEEP_FOOD;
    }

    @Override
    protected @NonNull InteractiveTag testMobInteraction(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        if (itemInHand.is(Items.SHEARS)) {
            return InteractiveTag.SHEAR;
        }
        InteractiveTag tag = super.testMobInteraction(hand, itemInHand);
        if (tag != InteractiveTag.NONE) {
            return tag;
        }
        if (this.canDye(itemInHand)) {
            return InteractiveTag.DYE;
        }
        return InteractiveTag.NONE;
    }

    @Override
    protected @NonNull InteractionResult mobInteract(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        if (itemInHand.is(Items.SHEARS)) {
            return InteractionResult.CONSUME;
        }
        InteractionResult superResult = super.mobInteract(hand, itemInHand);
        if (superResult.consumesAction()) {
            return superResult;
        }
        if (this.canDye(itemInHand)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private boolean canDye(GeyserItemStack item) {
        DyeItem dyeItem;
        Item item2 = item.asItem();
        return item2 instanceof DyeItem && (dyeItem = (DyeItem)item2).dyeColor() != this.color && !this.getFlag(EntityFlag.SHEARED);
    }
}

