/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.network.netty.proxy;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.ProtocolDetectionResult;
import io.netty.handler.codec.haproxy.HAProxyCommand;
import io.netty.handler.codec.haproxy.HAProxyMessage;
import io.netty.handler.codec.haproxy.HAProxyProtocolException;
import io.netty.handler.codec.haproxy.HAProxyProtocolVersion;
import io.netty.handler.codec.haproxy.HAProxyProxiedProtocol;
import io.netty.util.ByteProcessor;
import io.netty.util.CharsetUtil;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ProxyProtocolDecoder {
    private static final ProtocolDetectionResult<HAProxyProtocolVersion> DETECTION_RESULT_V1 = ProtocolDetectionResult.detected((Object)((Object)HAProxyProtocolVersion.V1));
    private static final ProtocolDetectionResult<HAProxyProtocolVersion> DETECTION_RESULT_V2 = ProtocolDetectionResult.detected((Object)((Object)HAProxyProtocolVersion.V2));
    private HeaderExtractor headerExtractor;
    private boolean discarding;
    private int discardedBytes;
    private boolean finished;
    private final int decodingVersion;
    private final int v2MaxHeaderSize = 65551;
    static final byte[] BINARY_PREFIX = new byte[]{13, 10, 13, 10, 0, 13, 10, 81, 85, 73, 84, 10};
    static final int BINARY_PREFIX_LENGTH = BINARY_PREFIX.length;
    static final byte[] TEXT_PREFIX = new byte[]{80, 82, 79, 88, 89};

    private ProxyProtocolDecoder(int version) {
        this.decodingVersion = version;
    }

    public static @Nullable HAProxyMessage decode(ByteBuf packet, int version) {
        if (version == -1) {
            return null;
        }
        ProxyProtocolDecoder decoder = new ProxyProtocolDecoder(version);
        return decoder.decodeHeader(packet);
    }

    private @Nullable HAProxyMessage decodeHeader(ByteBuf in) {
        ByteBuf decoded;
        ByteBuf byteBuf = decoded = this.decodingVersion == 1 ? this.decodeLine(in) : this.decodeStruct(in);
        if (decoded == null) {
            return null;
        }
        this.finished = true;
        try {
            if (this.decodingVersion == 1) {
                return ProxyProtocolDecoder.decodeHeader(decoded.toString(CharsetUtil.US_ASCII));
            }
            return ProxyProtocolDecoder.decodeHeader0(decoded);
        }
        catch (HAProxyProtocolException e) {
            throw this.fail(null, (Exception)((Object)e));
        }
    }

    static HAProxyMessage decodeHeader0(ByteBuf header) {
        String dstAddress;
        String srcAddress;
        HAProxyProxiedProtocol protAndFam;
        HAProxyCommand cmd;
        HAProxyProtocolVersion ver;
        Objects.requireNonNull(header, "header");
        if (header.readableBytes() < 16) {
            throw new HAProxyProtocolException("incomplete header: " + header.readableBytes() + " bytes (expected: 16+ bytes)");
        }
        header.skipBytes(12);
        byte verCmdByte = header.readByte();
        try {
            ver = HAProxyProtocolVersion.valueOf(verCmdByte);
        }
        catch (IllegalArgumentException e) {
            throw new HAProxyProtocolException(e);
        }
        if (ver != HAProxyProtocolVersion.V2) {
            throw new HAProxyProtocolException("version 1 unsupported: 0x" + Integer.toHexString(verCmdByte));
        }
        try {
            cmd = HAProxyCommand.valueOf(verCmdByte);
        }
        catch (IllegalArgumentException e) {
            throw new HAProxyProtocolException(e);
        }
        if (cmd == HAProxyCommand.LOCAL) {
            return ProxyProtocolDecoder.unknownMsg(HAProxyProtocolVersion.V2, HAProxyCommand.LOCAL);
        }
        try {
            protAndFam = HAProxyProxiedProtocol.valueOf(header.readByte());
        }
        catch (IllegalArgumentException e) {
            throw new HAProxyProtocolException(e);
        }
        if (protAndFam == HAProxyProxiedProtocol.UNKNOWN) {
            return ProxyProtocolDecoder.unknownMsg(HAProxyProtocolVersion.V2, HAProxyCommand.PROXY);
        }
        int addressInfoLen = header.readUnsignedShort();
        int srcPort = 0;
        int dstPort = 0;
        HAProxyProxiedProtocol.AddressFamily addressFamily = protAndFam.addressFamily();
        if (addressFamily == HAProxyProxiedProtocol.AddressFamily.AF_UNIX) {
            if (addressInfoLen < 216 || header.readableBytes() < 216) {
                throw new HAProxyProtocolException("incomplete UNIX socket address information: " + Math.min(addressInfoLen, header.readableBytes()) + " bytes (expected: 216+ bytes)");
            }
            int startIdx = header.readerIndex();
            int addressEnd = header.forEachByte(startIdx, 108, ByteProcessor.FIND_NUL);
            addressLen = addressEnd == -1 ? 108 : addressEnd - startIdx;
            srcAddress = header.toString(startIdx, addressLen, CharsetUtil.US_ASCII);
            addressEnd = header.forEachByte(startIdx += 108, 108, ByteProcessor.FIND_NUL);
            addressLen = addressEnd == -1 ? 108 : addressEnd - startIdx;
            dstAddress = header.toString(startIdx, addressLen, CharsetUtil.US_ASCII);
            header.readerIndex(startIdx + 108);
        } else {
            if (addressFamily == HAProxyProxiedProtocol.AddressFamily.AF_IPv4) {
                if (addressInfoLen < 12 || header.readableBytes() < 12) {
                    throw new HAProxyProtocolException("incomplete IPv4 address information: " + Math.min(addressInfoLen, header.readableBytes()) + " bytes (expected: 12+ bytes)");
                }
                addressLen = 4;
            } else if (addressFamily == HAProxyProxiedProtocol.AddressFamily.AF_IPv6) {
                if (addressInfoLen < 36 || header.readableBytes() < 36) {
                    throw new HAProxyProtocolException("incomplete IPv6 address information: " + Math.min(addressInfoLen, header.readableBytes()) + " bytes (expected: 36+ bytes)");
                }
                addressLen = 16;
            } else {
                throw new HAProxyProtocolException("unable to parse address information (unknown address family: " + String.valueOf((Object)addressFamily) + ")");
            }
            srcAddress = ProxyProtocolDecoder.ipBytesToString(header, addressLen);
            dstAddress = ProxyProtocolDecoder.ipBytesToString(header, addressLen);
            srcPort = header.readUnsignedShort();
            dstPort = header.readUnsignedShort();
        }
        while (ProxyProtocolDecoder.skipNextTLV(header)) {
        }
        return new HAProxyMessage(ver, cmd, protAndFam, srcAddress, dstAddress, srcPort, dstPort);
    }

    private static String ipBytesToString(ByteBuf header, int addressLen) {
        StringBuilder sb = new StringBuilder();
        int ipv4Len = 4;
        int ipv6Len = 8;
        if (addressLen == 4) {
            for (int i = 0; i < 4; ++i) {
                sb.append(header.readByte() & 0xFF);
                sb.append('.');
            }
        } else {
            for (int i = 0; i < 8; ++i) {
                sb.append(Integer.toHexString(header.readUnsignedShort()));
                sb.append(':');
            }
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    private static boolean skipNextTLV(ByteBuf header) {
        if (header.readableBytes() < 4) {
            return false;
        }
        header.skipBytes(1);
        header.skipBytes(header.readUnsignedShort());
        return true;
    }

    static HAProxyMessage decodeHeader(String header) {
        HAProxyProxiedProtocol protAndFam;
        if (header == null) {
            throw new HAProxyProtocolException("header");
        }
        String[] parts = header.split(" ");
        int numParts = parts.length;
        if (numParts < 2) {
            throw new HAProxyProtocolException("invalid header: " + header + " (expected: 'PROXY' and proxied protocol values)");
        }
        if (!"PROXY".equals(parts[0])) {
            throw new HAProxyProtocolException("unknown identifier: " + parts[0]);
        }
        try {
            protAndFam = HAProxyProxiedProtocol.valueOf(parts[1]);
        }
        catch (IllegalArgumentException e) {
            throw new HAProxyProtocolException(e);
        }
        if (protAndFam != HAProxyProxiedProtocol.TCP4 && protAndFam != HAProxyProxiedProtocol.TCP6 && protAndFam != HAProxyProxiedProtocol.UNKNOWN) {
            throw new HAProxyProtocolException("unsupported v1 proxied protocol: " + parts[1]);
        }
        if (protAndFam == HAProxyProxiedProtocol.UNKNOWN) {
            return ProxyProtocolDecoder.unknownMsg(HAProxyProtocolVersion.V1, HAProxyCommand.PROXY);
        }
        if (numParts != 6) {
            throw new HAProxyProtocolException("invalid TCP4/6 header: " + header + " (expected: 6 parts)");
        }
        try {
            return new HAProxyMessage(HAProxyProtocolVersion.V1, HAProxyCommand.PROXY, protAndFam, parts[2], parts[3], ProxyProtocolDecoder.portStringToInt(parts[4]), ProxyProtocolDecoder.portStringToInt(parts[5]));
        }
        catch (RuntimeException e) {
            throw new HAProxyProtocolException("invalid HAProxy message", e);
        }
    }

    private static int portStringToInt(String value) {
        int port;
        try {
            port = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("invalid port: " + value, e);
        }
        if (port <= 0 || port > 65535) {
            throw new IllegalArgumentException("invalid port: " + value + " (expected: 1 ~ 65535)");
        }
        return port;
    }

    private static HAProxyMessage unknownMsg(HAProxyProtocolVersion version, HAProxyCommand command) {
        return new HAProxyMessage(version, command, HAProxyProxiedProtocol.UNKNOWN, null, null, 0, 0);
    }

    public static int findVersion(ByteBuf buffer) {
        int n = buffer.readableBytes();
        if (n < 13) {
            return -1;
        }
        int idx = buffer.readerIndex();
        return ProxyProtocolDecoder.match(BINARY_PREFIX, buffer, idx) ? (int)buffer.getByte(idx + BINARY_PREFIX_LENGTH) : 1;
    }

    private ByteBuf decodeStruct(ByteBuf buffer) {
        if (this.headerExtractor == null) {
            this.headerExtractor = new StructHeaderExtractor(65551);
        }
        return this.headerExtractor.extract(buffer);
    }

    private ByteBuf decodeLine(ByteBuf buffer) {
        if (this.headerExtractor == null) {
            this.headerExtractor = new LineHeaderExtractor(108);
        }
        return this.headerExtractor.extract(buffer);
    }

    private void failOverLimit(String length) {
        int maxLength = this.decodingVersion == 1 ? 108 : 65551;
        throw this.fail("header length (" + length + ") exceeds the allowed maximum (" + maxLength + ")", null);
    }

    private HAProxyProtocolException fail(String errMsg, Exception e) {
        this.finished = true;
        HAProxyProtocolException ppex = errMsg != null && e != null ? new HAProxyProtocolException(errMsg, e) : (errMsg != null ? new HAProxyProtocolException(errMsg) : (e != null ? new HAProxyProtocolException(e) : new HAProxyProtocolException()));
        return ppex;
    }

    public static ProtocolDetectionResult<HAProxyProtocolVersion> detectProtocol(ByteBuf buffer) {
        if (buffer.readableBytes() < 12) {
            return ProtocolDetectionResult.needsMoreData();
        }
        int idx = buffer.readerIndex();
        if (ProxyProtocolDecoder.match(BINARY_PREFIX, buffer, idx)) {
            return DETECTION_RESULT_V2;
        }
        if (ProxyProtocolDecoder.match(TEXT_PREFIX, buffer, idx)) {
            return DETECTION_RESULT_V1;
        }
        return ProtocolDetectionResult.invalid();
    }

    private static boolean match(byte[] prefix, ByteBuf buffer, int idx) {
        for (int i = 0; i < prefix.length; ++i) {
            byte b = buffer.getByte(idx + i);
            if (b == prefix[i]) continue;
            return false;
        }
        return true;
    }

    private abstract class HeaderExtractor {
        private final int maxHeaderSize;

        protected HeaderExtractor(int maxHeaderSize) {
            this.maxHeaderSize = maxHeaderSize;
        }

        public @Nullable ByteBuf extract(ByteBuf buffer) {
            int eoh = this.findEndOfHeader(buffer);
            if (!ProxyProtocolDecoder.this.discarding) {
                if (eoh >= 0) {
                    int length = eoh - buffer.readerIndex();
                    if (length > this.maxHeaderSize) {
                        buffer.readerIndex(eoh + this.delimiterLength(buffer, eoh));
                        ProxyProtocolDecoder.this.failOverLimit(String.valueOf(length));
                        return null;
                    }
                    ByteBuf frame = buffer.readSlice(length);
                    buffer.skipBytes(this.delimiterLength(buffer, eoh));
                    return frame;
                }
                int length = buffer.readableBytes();
                if (length > this.maxHeaderSize) {
                    ProxyProtocolDecoder.this.discardedBytes = length;
                    buffer.skipBytes(length);
                    ProxyProtocolDecoder.this.discarding = true;
                    ProxyProtocolDecoder.this.failOverLimit("over " + ProxyProtocolDecoder.this.discardedBytes);
                }
                return null;
            }
            if (eoh >= 0) {
                int length = ProxyProtocolDecoder.this.discardedBytes + eoh - buffer.readerIndex();
                buffer.readerIndex(eoh + this.delimiterLength(buffer, eoh));
                ProxyProtocolDecoder.this.discardedBytes = 0;
                ProxyProtocolDecoder.this.discarding = false;
                ProxyProtocolDecoder.this.failOverLimit("over " + length);
            } else {
                ProxyProtocolDecoder.this.discardedBytes += buffer.readableBytes();
                buffer.skipBytes(buffer.readableBytes());
            }
            return null;
        }

        protected abstract int findEndOfHeader(ByteBuf var1);

        protected abstract int delimiterLength(ByteBuf var1, int var2);
    }

    private final class StructHeaderExtractor
    extends HeaderExtractor {
        StructHeaderExtractor(int maxHeaderSize) {
            super(maxHeaderSize);
        }

        @Override
        protected int findEndOfHeader(ByteBuf buffer) {
            int n = buffer.readableBytes();
            if (n < 16) {
                return -1;
            }
            int offset = buffer.readerIndex() + 14;
            int totalHeaderBytes = 16 + buffer.getUnsignedShort(offset);
            if (n >= totalHeaderBytes) {
                return totalHeaderBytes;
            }
            return -1;
        }

        @Override
        protected int delimiterLength(ByteBuf buffer, int eoh) {
            return 0;
        }
    }

    private final class LineHeaderExtractor
    extends HeaderExtractor {
        LineHeaderExtractor(int maxHeaderSize) {
            super(maxHeaderSize);
        }

        @Override
        protected int findEndOfHeader(ByteBuf buffer) {
            int n = buffer.writerIndex();
            for (int i = buffer.readerIndex(); i < n; ++i) {
                byte b = buffer.getByte(i);
                if (b != 13 || i >= n - 1 || buffer.getByte(i + 1) != 10) continue;
                return i;
            }
            return -1;
        }

        @Override
        protected int delimiterLength(ByteBuf buffer, int eoh) {
            return buffer.getByte(eoh) == 13 ? 2 : 1;
        }
    }
}

