/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.cache.registry;

import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.key.Key;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.registry.RegistryEntryData;

public record JavaRegistryKey<T>(Key registryKey, RegistryLookup<T> lookup) {
    public int networkId(GeyserSession session, T object) {
        return this.entry(session, object).map(RegistryEntryData::id).orElse(-1);
    }

    public int networkId(GeyserSession session, Key key) {
        return this.entry(session, key).map(RegistryEntryData::id).orElse(-1);
    }

    public @Nullable Key key(GeyserSession session, T object) {
        return this.entry(session, object).map(RegistryEntryData::key).orElse(null);
    }

    public @Nullable Key key(GeyserSession session, int networkId) {
        return this.entry(session, networkId).map(RegistryEntryData::key).orElse(null);
    }

    public @Nullable T value(GeyserSession session, int networkId) {
        return this.entry(session, networkId).map(RegistryEntryData::data).orElse(null);
    }

    public @Nullable T value(GeyserSession session, Key key) {
        return this.entry(session, key).map(RegistryEntryData::data).orElse(null);
    }

    private Optional<RegistryEntryData<T>> entry(GeyserSession session, T object) {
        return this.lookup.entry(session, this, object);
    }

    private Optional<RegistryEntryData<T>> entry(GeyserSession session, int networkId) {
        return this.lookup.entry(session, (JavaRegistryKey<int>)this, networkId);
    }

    private Optional<RegistryEntryData<T>> entry(GeyserSession session, Key key) {
        return this.lookup.entry(session, (JavaRegistryKey<Key>)this, key);
    }

    @Override
    public @NonNull String toString() {
        return "Java registry: " + String.valueOf(this.registryKey);
    }

    public static interface RegistryLookup<T> {
        public Optional<RegistryEntryData<T>> entry(GeyserSession var1, JavaRegistryKey<T> var2, int var3);

        public Optional<RegistryEntryData<T>> entry(GeyserSession var1, JavaRegistryKey<T> var2, Key var3);

        public Optional<RegistryEntryData<T>> entry(GeyserSession var1, JavaRegistryKey<T> var2, T var3);
    }
}

