/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory;

import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerSlotType;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.ItemStackRequest;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.ItemStackRequestSlotData;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.ItemStackRequestAction;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.SwapAction;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.TransferItemStackRequestAction;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.response.ItemStackResponse;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.click.Click;
import org.geysermc.geyser.inventory.click.ClickPlan;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.IntSets;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.BundleCache;
import org.geysermc.geyser.translator.inventory.InventoryTranslator;
import org.geysermc.geyser.util.InventoryUtils;
import org.geysermc.geyser.util.thirdparty.Fraction;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.BeehiveOccupant;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;

public final class BundleInventoryTranslator {
    private static final Fraction BUNDLE_IN_BUNDLE_WEIGHT = Fraction.getFraction(1, 16);

    static @Nullable ItemStackResponse handleBundle(GeyserSession session, InventoryTranslator translator, Inventory inventory, ItemStackRequest request, boolean sendCreativePackets) {
        TransferItemStackRequestAction action = null;
        for (ItemStackRequestAction requestAction : request.getActions()) {
            if (requestAction instanceof SwapAction) {
                SwapAction swapAction = (SwapAction)requestAction;
                if (BundleInventoryTranslator.isBundle(swapAction.getSource()) && BundleInventoryTranslator.isBundle(swapAction.getDestination())) continue;
                return null;
            }
            if (!(requestAction instanceof TransferItemStackRequestAction)) {
                return null;
            }
            TransferItemStackRequestAction transferAction = (TransferItemStackRequestAction)requestAction;
            boolean sourceIsBundle = BundleInventoryTranslator.isBundle(transferAction.getSource());
            boolean destIsBundle = BundleInventoryTranslator.isBundle(transferAction.getDestination());
            if (sourceIsBundle && destIsBundle) continue;
            if (sourceIsBundle || destIsBundle) {
                action = transferAction;
                continue;
            }
            return null;
        }
        if (action == null) {
            return null;
        }
        ClickPlan plan = new ClickPlan(session, translator, inventory);
        if (BundleInventoryTranslator.isBundle(action.getDestination())) {
            ItemStackRequestSlotData bundleSlotData = action.getDestination();
            ItemStackRequestSlotData inventorySlotData = action.getSource();
            int bundleId = bundleSlotData.getContainerName().getDynamicId();
            cursor = session.getPlayerInventory().getCursor();
            if (cursor.getBundleId() == bundleId) {
                List<GeyserItemStack> contents = cursor.getBundleData().contents();
                int sourceSlot = translator.bedrockSlotToJava(inventorySlotData);
                GeyserItemStack sourceItem = inventory.getItem(sourceSlot);
                if (sourceItem.isEmpty()) {
                    return InventoryTranslator.rejectRequest(request);
                }
                if (inventorySlotData.getStackNetworkId() != sourceItem.getNetId()) {
                    return InventoryTranslator.rejectRequest(request);
                }
                Fraction bundleWeight = BundleInventoryTranslator.calculateBundleWeight(contents);
                int allowedCapacity = Math.min(BundleInventoryTranslator.capacityForItemStack(bundleWeight, sourceItem), sourceItem.getAmount());
                if (action.getCount() != allowedCapacity) {
                    return InventoryTranslator.rejectRequest(request);
                }
                plan.add(Click.LEFT_BUNDLE_FROM_CURSOR, sourceSlot);
                if (sendCreativePackets) {
                    plan.executeForCreativeMode();
                } else {
                    plan.execute(false);
                }
                return InventoryTranslator.acceptRequest(request, translator.makeContainerEntries(session, inventory, IntSets.singleton(sourceSlot)));
            }
            for (javaSlot = 0; javaSlot < inventory.getSize(); ++javaSlot) {
                int sourceSlot;
                boolean slotIsInventory;
                GeyserItemStack bundle = inventory.getItem(javaSlot);
                if (bundle.getBundleId() != bundleId) continue;
                if (!translator.checkNetId(session, inventory, inventorySlotData)) {
                    return InventoryTranslator.rejectRequest(request);
                }
                IntOpenHashSet affectedSlots = new IntOpenHashSet(2);
                affectedSlots.add(javaSlot);
                boolean bl = slotIsInventory = !InventoryTranslator.isCursor(inventorySlotData);
                if (slotIsInventory) {
                    sourceSlot = translator.bedrockSlotToJava(inventorySlotData);
                    plan.add(Click.LEFT, sourceSlot);
                    affectedSlots.add(sourceSlot);
                } else {
                    sourceSlot = -1;
                }
                Fraction bundleWeight = BundleInventoryTranslator.calculateBundleWeight(bundle.getBundleData().contents());
                int allowedCapacity = Math.min(BundleInventoryTranslator.capacityForItemStack(bundleWeight, plan.getCursor()), plan.getCursor().getAmount());
                if (action.getCount() != allowedCapacity) {
                    return InventoryTranslator.rejectRequest(request);
                }
                plan.add(Click.LEFT_BUNDLE, javaSlot);
                if (slotIsInventory && allowedCapacity != plan.getCursor().getAmount()) {
                    plan.add(Click.LEFT, sourceSlot);
                }
                if (sendCreativePackets) {
                    plan.executeForCreativeMode();
                } else {
                    plan.execute(false);
                }
                return InventoryTranslator.acceptRequest(request, translator.makeContainerEntries(session, inventory, affectedSlots));
            }
        } else {
            ItemStackRequestSlotData bundleSlotData = action.getSource();
            ItemStackRequestSlotData inventorySlotData = action.getDestination();
            int bundleId = bundleSlotData.getContainerName().getDynamicId();
            cursor = session.getPlayerInventory().getCursor();
            if (cursor.getBundleId() == bundleId) {
                List<GeyserItemStack> contents = cursor.getBundleData().contents();
                if (contents.isEmpty()) {
                    return InventoryTranslator.rejectRequest(request);
                }
                if (bundleSlotData.getStackNetworkId() != contents.get(0).getNetId()) {
                    return InventoryTranslator.rejectRequest(request);
                }
                int destSlot = translator.bedrockSlotToJava(inventorySlotData);
                if (!inventory.getItem(destSlot).isEmpty()) {
                    return InventoryTranslator.rejectRequest(request);
                }
                plan.add(Click.RIGHT_BUNDLE, destSlot);
                if (sendCreativePackets) {
                    plan.executeForCreativeMode();
                } else {
                    plan.execute(false);
                }
                return InventoryTranslator.acceptRequest(request, translator.makeContainerEntries(session, inventory, IntSets.singleton(destSlot)));
            }
            for (javaSlot = 0; javaSlot < inventory.getSize(); ++javaSlot) {
                GeyserItemStack bundle = inventory.getItem(javaSlot);
                if (bundle.getBundleId() != bundleId) continue;
                List<GeyserItemStack> contents = bundle.getBundleData().contents();
                int rawSelectedSlot = bundleSlotData.getSlot();
                if (rawSelectedSlot >= contents.size()) {
                    return InventoryTranslator.rejectRequest(request);
                }
                int slot = BundleCache.platformConvertSlot(contents.size(), rawSelectedSlot);
                plan.setDesiredBundleSlot(slot);
                if (!cursor.isEmpty()) {
                    return InventoryTranslator.rejectRequest(request);
                }
                IntOpenHashSet affectedSlots = new IntOpenHashSet(2);
                affectedSlots.add(javaSlot);
                GeyserItemStack bundledItem = contents.get(slot);
                if (bundledItem.getNetId() != bundleSlotData.getStackNetworkId()) {
                    return InventoryTranslator.rejectRequest(request);
                }
                plan.add(Click.RIGHT_BUNDLE, javaSlot);
                if (!InventoryTranslator.isCursor(inventorySlotData)) {
                    int destSlot = translator.bedrockSlotToJava(inventorySlotData);
                    GeyserItemStack existing = inventory.getItem(destSlot);
                    if (!existing.isEmpty() && !InventoryUtils.canStack(bundledItem, existing)) {
                        return InventoryTranslator.rejectRequest(request);
                    }
                    plan.add(Click.LEFT, destSlot);
                    affectedSlots.add(destSlot);
                }
                if (sendCreativePackets) {
                    plan.executeForCreativeMode();
                } else {
                    plan.execute(false);
                }
                return InventoryTranslator.acceptRequest(request, translator.makeContainerEntries(session, inventory, affectedSlots));
            }
        }
        return InventoryTranslator.rejectRequest(request);
    }

    public static Fraction calculateBundleWeight(List<GeyserItemStack> contents) {
        Fraction fraction = Fraction.ZERO;
        for (GeyserItemStack content : contents) {
            fraction = fraction.add(BundleInventoryTranslator.calculateWeight(content).multiplyBy(Fraction.getFraction(content.getAmount(), 1)));
        }
        return fraction;
    }

    private static Fraction calculateWeight(GeyserItemStack itemStack) {
        List<BeehiveOccupant> bees;
        if (itemStack.getBundleData() != null) {
            return BUNDLE_IN_BUNDLE_WEIGHT.add(BundleInventoryTranslator.calculateBundleWeight(itemStack.getBundleData().contents()));
        }
        DataComponents components = itemStack.getComponents();
        if (components != null && (bees = components.get(DataComponentTypes.BEES)) != null && !bees.isEmpty()) {
            return Fraction.ONE;
        }
        return Fraction.getFraction(1, itemStack.getComponentElseGet(DataComponentTypes.MAX_STACK_SIZE, () -> itemStack.asItem().defaultMaxStackSize()));
    }

    public static int capacityForItemStack(Fraction bundleWeight, GeyserItemStack itemStack) {
        Fraction inverse = Fraction.ONE.subtract(bundleWeight);
        return Math.max(inverse.divideBy(BundleInventoryTranslator.calculateWeight(itemStack)).intValue(), 0);
    }

    static boolean isBundle(ItemStackRequestSlotData slotData) {
        return slotData.getContainerName().getContainer() == ContainerSlotType.DYNAMIC_CONTAINER;
    }

    static boolean isBundle(ClickPlan plan, int slot) {
        return BundleInventoryTranslator.isBundle(plan.getItem(slot));
    }

    static boolean isBundle(GeyserItemStack stack) {
        return stack.getBundleData() != null;
    }

    private BundleInventoryTranslator() {
    }
}

