/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.erosion.bukkit.nms;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.geysermc.erosion.bukkit.PickItemProvider;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;

public class NmsPickItemProvider
implements PickItemProvider {
    @Override
    public Int2ObjectMap<byte[]> getPickItem(Block block) {
        CraftBlock craftBlock = (CraftBlock)block;
        BlockState state = craftBlock.getNMS();
        ServerLevel level = craftBlock.getCraftWorld().getHandle();
        ItemStack stack = state.getBlock().getCloneItemStack((LevelReader)level, craftBlock.getPosition(), state);
        Int2ObjectOpenHashMap<byte[]> components = new Int2ObjectOpenHashMap<byte[]>();
        Function decorator = RegistryFriendlyByteBuf.decorator((RegistryAccess)level.registryAccess());
        for (Map.Entry entry : stack.getComponentsPatch().entrySet()) {
            DataComponentType key = (DataComponentType)entry.getKey();
            if (key == DataComponents.CUSTOM_DATA || key == DataComponents.CONTAINER || key == DataComponents.CONTAINER_LOOT || key == DataComponents.BUNDLE_CONTENTS) continue;
            ((Optional)entry.getValue()).ifPresent(value -> {
                RegistryFriendlyByteBuf buf = (RegistryFriendlyByteBuf)decorator.apply(Unpooled.buffer());
                NmsPickItemProvider.encodeComponent(buf, key, value);
                components.put(BuiltInRegistries.DATA_COMPONENT_TYPE.getId((Object)key), ByteBufUtil.getBytes((ByteBuf)buf));
            });
        }
        return components;
    }

    private static <T> void encodeComponent(RegistryFriendlyByteBuf buf, DataComponentType<T> type, Object value) {
        type.streamCodec().encode((Object)buf, value);
    }
}

