/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.text;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.GeyserBootstrap;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.platform.velocity.shaded.it.unimi.dsi.fastutil.objects.ObjectArrays;

public class GeyserLocale {
    private static String DEFAULT_LOCALE;
    private static boolean SYSTEM_LOCALE_INVALID;
    private static final Map<String, Properties> LOCALE_MAPPINGS;

    public static void init(GeyserBootstrap bootstrap) {
        String defaultLocale = GeyserLocale.formatLocale(Locale.getDefault().getLanguage() + "_" + Locale.getDefault().getCountry());
        String loadedLocale = GeyserLocale.loadGeyserLocale(defaultLocale, bootstrap);
        if (loadedLocale != null) {
            DEFAULT_LOCALE = loadedLocale;
            if (!"en_US".equals(loadedLocale)) {
                GeyserLocale.loadGeyserLocale("en_US", bootstrap);
            }
            SYSTEM_LOCALE_INVALID = false;
        } else {
            DEFAULT_LOCALE = GeyserLocale.loadGeyserLocale("en_US", bootstrap);
            if (DEFAULT_LOCALE == null) {
                throw new IllegalStateException("English locale not found in Geyser. Did you clone the submodules? (git submodule update --init)");
            }
            SYSTEM_LOCALE_INVALID = true;
        }
    }

    public static void finalizeDefaultLocale(GeyserImpl geyser) {
        String newDefaultLocale = geyser.getConfig().getDefaultLocale();
        if (newDefaultLocale == null) {
            return;
        }
        String loadedNewLocale = GeyserLocale.loadGeyserLocale(newDefaultLocale, geyser.getBootstrap());
        if (loadedNewLocale != null) {
            DEFAULT_LOCALE = loadedNewLocale;
        } else if (SYSTEM_LOCALE_INVALID) {
            geyser.getLogger().warning(Locale.getDefault().toString() + " is not a valid Bedrock language.");
        }
    }

    public static String getDefaultLocale() {
        return DEFAULT_LOCALE;
    }

    public static void loadGeyserLocale(String locale) {
        GeyserImpl geyser = GeyserImpl.getInstance();
        if (geyser == null) {
            throw new IllegalStateException("Geyser instance cannot be null when loading a locale!");
        }
        GeyserLocale.loadGeyserLocale(locale, geyser.getBootstrap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static @Nullable String loadGeyserLocale(String locale, GeyserBootstrap bootstrap) {
        if (LOCALE_MAPPINGS.containsKey(locale = GeyserLocale.formatLocale(locale))) {
            return locale;
        }
        Properties localeProp = new Properties();
        Path localFolder = bootstrap.getConfigFolder().resolve("languages");
        File localLanguage = Files.exists(localFolder, new LinkOption[0]) ? localFolder.resolve(locale + ".properties").toFile() : null;
        boolean validLocalLanguage = localLanguage != null && localLanguage.exists();
        InputStream localeStream = bootstrap.getResourceOrNull("languages/texts/" + locale + ".properties");
        if (localeStream != null) {
            try {
                try (InputStreamReader reader = new InputStreamReader(localeStream, StandardCharsets.UTF_8);){
                    localeProp.load(reader);
                }
                catch (Exception e) {
                    throw new AssertionError(GeyserLocale.getLocaleStringLog("geyser.language.load_failed", locale), e);
                }
                LOCALE_MAPPINGS.put(locale, localeProp);
            }
            finally {
                try {
                    localeStream.close();
                }
                catch (IOException e) {}
            }
        }
        if (!validLocalLanguage) {
            bootstrap.getGeyserLogger().debug("Missing locale: " + locale);
        }
        if (validLocalLanguage) {
            try (FileInputStream stream = new FileInputStream(localLanguage);){
                localeProp.load(stream);
            }
            catch (IOException e) {
                String message = "Unable to load custom language override!";
                bootstrap.getGeyserLogger().error(message, e);
            }
            LOCALE_MAPPINGS.putIfAbsent(locale, localeProp);
        }
        return localeProp.isEmpty() ? null : locale;
    }

    public static String getLocaleStringLog(String key) {
        return GeyserLocale.getLocaleStringLog(key, ObjectArrays.EMPTY_ARRAY);
    }

    public static String getLocaleStringLog(String key, Object ... values) {
        return GeyserLocale.getPlayerLocaleString(key, GeyserLocale.getDefaultLocale(), values);
    }

    public static String getPlayerLocaleString(String key, String locale) {
        return GeyserLocale.getPlayerLocaleString(key, locale, ObjectArrays.EMPTY_ARRAY);
    }

    public static String getPlayerLocaleString(String key, String locale, Object ... values) {
        locale = GeyserLocale.formatLocale(locale);
        Properties properties = LOCALE_MAPPINGS.get(locale);
        String formatString = null;
        if (properties != null) {
            formatString = properties.getProperty(key);
        }
        if (formatString == null && (formatString = (properties = LOCALE_MAPPINGS.get(GeyserLocale.getDefaultLocale())).getProperty(key)) == null && (formatString = (properties = LOCALE_MAPPINGS.get("en_US")).getProperty(key)) == null) {
            return key;
        }
        String message = formatString.replace("&", "\u00a7");
        if (values == null || values.length == 0) {
            return message;
        }
        return MessageFormat.format(message.replace("'", "''"), values);
    }

    public static String formatLocale(String locale) {
        if (locale.length() != 5 || locale.indexOf(95) != 2) {
            return locale;
        }
        String lowerCaseLocale = locale.toLowerCase(Locale.ROOT);
        if (lowerCaseLocale.equals("nn_no") || lowerCaseLocale.equals("no_no")) {
            locale = "nb_NO";
        }
        String language = locale.substring(0, 2);
        String country = locale.substring(3);
        return language.toLowerCase(Locale.ENGLISH) + "_" + country.toUpperCase(Locale.ENGLISH);
    }

    static {
        LOCALE_MAPPINGS = new HashMap<String, Properties>();
    }
}

