/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.geysermc.erosion.util.LecternUtils;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.LecternContainer;
import org.geysermc.geyser.inventory.PlayerInventory;
import org.geysermc.geyser.inventory.updater.ContainerInventoryUpdater;
import org.geysermc.geyser.inventory.updater.InventoryUpdater;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.level.block.property.Properties;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.level.block.type.LecternBlock;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.AbstractBlockInventoryTranslator;
import org.geysermc.geyser.translator.inventory.InventoryTranslator;
import org.geysermc.geyser.util.BlockEntityUtils;
import org.geysermc.geyser.util.InventoryUtils;
import org.geysermc.mcprotocollib.protocol.data.game.inventory.ContainerType;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.WritableBookContent;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.WrittenBookContent;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.inventory.ServerboundContainerButtonClickPacket;

public class LecternInventoryTranslator
extends AbstractBlockInventoryTranslator {
    private boolean receivedBook = false;

    public LecternInventoryTranslator() {
        super(1, Blocks.LECTERN, org.cloudburstmc.protocol.bedrock.data.inventory.ContainerType.LECTERN, (InventoryUpdater)ContainerInventoryUpdater.INSTANCE, new Block[0]);
    }

    @Override
    public boolean prepareInventory(GeyserSession session, Inventory inventory) {
        super.prepareInventory(session, inventory);
        if (((LecternContainer)inventory).isBookInPlayerInventory()) {
            this.updateBook(session, inventory, inventory.getItem(0));
            this.receivedBook = true;
        } else {
            this.receivedBook = false;
        }
        return true;
    }

    @Override
    public void openInventory(GeyserSession session, Inventory inventory) {
        if (this.receivedBook && !session.isDroppingLecternBook()) {
            super.openInventory(session, inventory);
        }
    }

    @Override
    public void closeInventory(GeyserSession session, Inventory inventory) {
        LecternContainer lecternContainer = (LecternContainer)inventory;
        Vector3i position = lecternContainer.isUsingRealBlock() ? session.getLastInteractionBlockPosition() : inventory.getHolderPosition();
        NbtMapBuilder baseLecternTag = LecternUtils.getBaseLecternTag(position.getX(), position.getY(), position.getZ(), 0);
        BlockEntityUtils.updateBlockEntity(session, baseLecternTag.build(), position);
        session.setPendingOrCurrentBedrockInventoryId(-1);
        super.closeInventory(session, inventory);
        if (lecternContainer.isUsingRealBlock()) {
            boolean hasBook = session.getGeyser().getWorldManager().blockAt(session, position).getValue(Properties.HAS_BOOK, false);
            NbtMap map = LecternBlock.getBaseLecternTag(position, hasBook);
            BlockEntityUtils.updateBlockEntity(session, map, position);
        }
    }

    @Override
    public void updateProperty(GeyserSession session, Inventory inventory, int key, int value) {
        if (key == 0) {
            LecternContainer lecternContainer = (LecternContainer)inventory;
            lecternContainer.setCurrentBedrockPage(value / 2);
            lecternContainer.setBlockEntityTag(lecternContainer.getBlockEntityTag().toBuilder().putInt("page", lecternContainer.getCurrentBedrockPage()).build());
            BlockEntityUtils.updateBlockEntity(session, lecternContainer.getBlockEntityTag(), lecternContainer.getPosition());
        }
    }

    @Override
    public void updateInventory(GeyserSession session, Inventory inventory) {
        GeyserItemStack itemStack = inventory.getItem(0);
        if (!itemStack.isEmpty()) {
            boolean isDropping = session.isDroppingLecternBook();
            this.updateBook(session, inventory, itemStack);
            if (!this.receivedBook && !isDropping) {
                this.receivedBook = true;
                this.openInventory(session, inventory);
            }
        }
    }

    @Override
    public void updateSlot(GeyserSession session, Inventory inventory, int slot) {
        if (((LecternContainer)inventory).isBookInPlayerInventory()) {
            InventoryTranslator.PLAYER_INVENTORY_TRANSLATOR.updateSlot(session, session.getPlayerInventory(), slot);
            return;
        }
        super.updateSlot(session, inventory, slot);
        if (slot == 0) {
            this.updateBook(session, inventory, inventory.getItem(0));
        }
    }

    @Override
    public @Nullable org.cloudburstmc.protocol.bedrock.data.inventory.ContainerType closeContainerType(Inventory inventory) {
        return null;
    }

    private void updateBook(GeyserSession session, Inventory inventory, GeyserItemStack book) {
        LecternContainer lecternContainer = (LecternContainer)inventory;
        if (session.isDroppingLecternBook()) {
            ServerboundContainerButtonClickPacket packet = new ServerboundContainerButtonClickPacket(inventory.getJavaId(), 3);
            session.sendDownstreamGamePacket(packet);
            session.setDroppingLecternBook(false);
            InventoryUtils.closeInventory(session, inventory.getJavaId(), false);
        } else if (lecternContainer.getBlockEntityTag() == null) {
            NbtMap blockEntityTag;
            Vector3i position;
            Vector3i vector3i = position = lecternContainer.isUsingRealBlock() ? session.getLastInteractionBlockPosition() : inventory.getHolderPosition();
            if (book.hasNonBaseComponents()) {
                int pages = 0;
                WrittenBookContent writtenBookComponents = book.getComponent(DataComponentTypes.WRITTEN_BOOK_CONTENT);
                if (writtenBookComponents != null) {
                    pages = writtenBookComponents.getPages().size();
                } else {
                    WritableBookContent writableBookComponents = book.getComponent(DataComponentTypes.WRITABLE_BOOK_CONTENT);
                    if (writableBookComponents != null) {
                        pages = writableBookComponents.getPages().size();
                    }
                }
                ItemData itemData = book.getItemData(session);
                NbtMapBuilder lecternTag = LecternBlock.getBaseLecternTag(position, pages);
                lecternTag.putCompound("book", NbtMap.builder().putByte("Count", (byte)itemData.getCount()).putShort("Damage", (short)0).putString("Name", "minecraft:written_book").putCompound("tag", itemData.getTag()).build());
                lecternTag.putInt("page", lecternContainer.getCurrentBedrockPage());
                blockEntityTag = lecternTag.build();
            } else {
                blockEntityTag = LecternBlock.getBaseLecternTag(position, true);
            }
            lecternContainer.setBlockEntityTag(blockEntityTag);
            lecternContainer.setPosition(position);
            BlockEntityUtils.updateBlockEntity(session, blockEntityTag, position);
        }
    }

    @Override
    public Inventory createInventory(GeyserSession session, String name, int windowId, ContainerType containerType, PlayerInventory playerInventory) {
        return new LecternContainer(session, name, windowId, this.size + playerInventory.getSize(), containerType, playerInventory, this);
    }
}

