/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.cumulus.component.impl;

import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;
import org.checkerframework.checker.index.qual.Positive;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.cumulus.component.SliderComponent;
import org.geysermc.cumulus.component.impl.ComponentImpl;
import org.geysermc.cumulus.component.util.ComponentType;

public final class SliderComponentImpl
extends ComponentImpl
implements SliderComponent {
    private final float min;
    private final float max;
    private final float step;
    @SerializedName(value="default")
    private final float defaultValue;

    public SliderComponentImpl(@NonNull String text, float min, float max, @Positive float step, float defaultValue) {
        super(ComponentType.SLIDER, text);
        Preconditions.checkArgument((step > 0.0f ? 1 : 0) != 0, (Object)"step value cannot be negative");
        Preconditions.checkArgument((min <= max ? 1 : 0) != 0, (Object)"min value is higher than max value");
        this.min = min;
        this.max = max;
        this.step = step;
        this.defaultValue = defaultValue;
    }

    public SliderComponentImpl(@NonNull String text, float min, float max, @Positive float step) {
        this(text, min, max, step, SliderComponentImpl.generateDefaultValue(min, max, step));
    }

    private static float generateDefaultValue(float min, float max, @Positive float step) {
        float middle = min + (max - min) / 2.0f;
        if ((middle - min) / step % 1.0f == 0.0f) {
            return middle;
        }
        if (min + step * 50.0f < max) {
            return min;
        }
        float previousStep = min;
        while (previousStep < max) {
            float next = previousStep + step;
            if (next > middle) {
                return previousStep;
            }
            previousStep = next;
        }
        return previousStep;
    }

    @Override
    public float minValue() {
        return this.min;
    }

    @Override
    public float maxValue() {
        return this.max;
    }

    @Override
    public @Positive float step() {
        return this.step;
    }

    @Override
    public float defaultValue() {
        return this.defaultValue;
    }

    @Override
    public float getMin() {
        return this.minValue();
    }

    @Override
    public float getMax() {
        return this.maxValue();
    }

    @Override
    public int getStep() {
        return (int)this.step();
    }

    @Override
    public float getDefaultValue() {
        return this.defaultValue();
    }
}

