/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.properties;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import org.cloudburstmc.protocol.bedrock.data.entity.FloatEntityProperty;
import org.cloudburstmc.protocol.bedrock.data.entity.IntEntityProperty;
import org.geysermc.geyser.entity.properties.GeyserEntityProperties;
import org.geysermc.geyser.entity.properties.type.EnumProperty;
import org.geysermc.geyser.entity.properties.type.PropertyType;

public class GeyserEntityPropertyManager {
    private final GeyserEntityProperties properties;
    private final ObjectArrayList<IntEntityProperty> intEntityProperties = new ObjectArrayList();
    private final ObjectArrayList<FloatEntityProperty> floatEntityProperties = new ObjectArrayList();

    public GeyserEntityPropertyManager(GeyserEntityProperties properties) {
        this.properties = properties;
    }

    public void add(String propertyName, int value) {
        int index = this.properties.getPropertyIndex(propertyName);
        this.intEntityProperties.add((Object)new IntEntityProperty(index, value));
    }

    public void add(String propertyName, boolean value) {
        int index = this.properties.getPropertyIndex(propertyName);
        this.intEntityProperties.add((Object)new IntEntityProperty(index, value ? 1 : 0));
    }

    public void add(String propertyName, String value) {
        int index = this.properties.getPropertyIndex(propertyName);
        PropertyType property = this.properties.getProperties().get(index);
        int enumIndex = ((EnumProperty)property).getIndex(value);
        this.intEntityProperties.add((Object)new IntEntityProperty(index, enumIndex));
    }

    public void add(String propertyName, float value) {
        int index = this.properties.getPropertyIndex(propertyName);
        this.floatEntityProperties.add((Object)new FloatEntityProperty(index, value));
    }

    public boolean hasFloatProperties() {
        return !this.floatEntityProperties.isEmpty();
    }

    public boolean hasIntProperties() {
        return !this.intEntityProperties.isEmpty();
    }

    public boolean hasProperties() {
        return this.hasFloatProperties() || this.hasIntProperties();
    }

    public ObjectArrayList<IntEntityProperty> intProperties() {
        return this.intEntityProperties;
    }

    public void applyIntProperties(List<IntEntityProperty> properties) {
        properties.addAll((Collection<IntEntityProperty>)this.intEntityProperties);
        this.intEntityProperties.clear();
    }

    public ObjectArrayList<FloatEntityProperty> floatProperties() {
        return this.floatEntityProperties;
    }

    public void applyFloatProperties(List<FloatEntityProperty> properties) {
        properties.addAll((Collection<FloatEntityProperty>)this.floatEntityProperties);
        this.floatEntityProperties.clear();
    }
}

