/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.cache.registry;

import java.util.Optional;
import net.kyori.adventure.key.Key;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.registry.JavaRegistryProvider;
import org.geysermc.geyser.session.cache.registry.RegistryEntryData;

public record JavaRegistryKey<T>(Key registryKey, RegistryLookup<T> lookup) {
    public int networkId(GeyserSession session, T object) {
        return this.networkId((JavaRegistryProvider)session.getRegistryCache(), object);
    }

    public int networkId(JavaRegistryProvider registries, T object) {
        return this.entry(registries, object).map(RegistryEntryData::id).orElse(-1);
    }

    public int networkId(GeyserSession session, Key key) {
        return this.networkId((JavaRegistryProvider)session.getRegistryCache(), key);
    }

    public int networkId(JavaRegistryProvider registries, Key key) {
        return this.entry(registries, key).map(RegistryEntryData::id).orElse(-1);
    }

    public @Nullable Key key(GeyserSession session, T object) {
        return this.key((JavaRegistryProvider)session.getRegistryCache(), object);
    }

    public @Nullable Key key(JavaRegistryProvider registries, T object) {
        return this.entry(registries, object).map(RegistryEntryData::key).orElse(null);
    }

    public @Nullable Key key(GeyserSession session, int networkId) {
        return this.key((JavaRegistryProvider)session.getRegistryCache(), networkId);
    }

    public @Nullable Key key(JavaRegistryProvider registries, int networkId) {
        return this.entry(registries, networkId).map(RegistryEntryData::key).orElse(null);
    }

    public @Nullable T value(GeyserSession session, int networkId) {
        return this.value((JavaRegistryProvider)session.getRegistryCache(), networkId);
    }

    public @Nullable T value(JavaRegistryProvider registries, int networkId) {
        return this.entry(registries, networkId).map(RegistryEntryData::data).orElse(null);
    }

    public @Nullable T value(GeyserSession session, Key key) {
        return this.value((JavaRegistryProvider)session.getRegistryCache(), key);
    }

    public @Nullable T value(JavaRegistryProvider registries, Key key) {
        return this.entry(registries, key).map(RegistryEntryData::data).orElse(null);
    }

    private Optional<RegistryEntryData<T>> entry(JavaRegistryProvider registries, T object) {
        return this.lookup.entry(registries, this, object);
    }

    private Optional<RegistryEntryData<T>> entry(JavaRegistryProvider registries, int networkId) {
        return this.lookup.entry(registries, (JavaRegistryKey<int>)this, networkId);
    }

    private Optional<RegistryEntryData<T>> entry(JavaRegistryProvider registries, Key key) {
        return this.lookup.entry(registries, (JavaRegistryKey<Key>)this, key);
    }

    @Override
    public @NonNull String toString() {
        return "Java registry: " + String.valueOf(this.registryKey);
    }

    public static interface RegistryLookup<T> {
        public Optional<RegistryEntryData<T>> entry(JavaRegistryProvider var1, JavaRegistryKey<T> var2, int var3);

        public Optional<RegistryEntryData<T>> entry(JavaRegistryProvider var1, JavaRegistryKey<T> var2, Key var3);

        public Optional<RegistryEntryData<T>> entry(JavaRegistryProvider var1, JavaRegistryKey<T> var2, T var3);
    }
}

