/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet;

import java.util.Arrays;
import java.util.UUID;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.ResourcePackType;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.BedrockPacketHandler;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.BedrockPacketType;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.common.PacketSignal;

public class ResourcePackDataInfoPacket
implements BedrockPacket {
    private UUID packId;
    private String packVersion;
    private long maxChunkSize;
    private long chunkCount;
    private long compressedPackSize;
    private byte[] hash;
    private boolean premium;
    private ResourcePackType type;

    @Override
    public final PacketSignal handle(BedrockPacketHandler handler) {
        return handler.handle(this);
    }

    @Override
    public BedrockPacketType getPacketType() {
        return BedrockPacketType.RESOURCE_PACK_DATA_INFO;
    }

    @Override
    public ResourcePackDataInfoPacket clone() {
        try {
            return (ResourcePackDataInfoPacket)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public UUID getPackId() {
        return this.packId;
    }

    public String getPackVersion() {
        return this.packVersion;
    }

    public long getMaxChunkSize() {
        return this.maxChunkSize;
    }

    public long getChunkCount() {
        return this.chunkCount;
    }

    public long getCompressedPackSize() {
        return this.compressedPackSize;
    }

    public byte[] getHash() {
        return this.hash;
    }

    public boolean isPremium() {
        return this.premium;
    }

    public ResourcePackType getType() {
        return this.type;
    }

    public void setPackId(UUID packId) {
        this.packId = packId;
    }

    public void setPackVersion(String packVersion) {
        this.packVersion = packVersion;
    }

    public void setMaxChunkSize(long maxChunkSize) {
        this.maxChunkSize = maxChunkSize;
    }

    public void setChunkCount(long chunkCount) {
        this.chunkCount = chunkCount;
    }

    public void setCompressedPackSize(long compressedPackSize) {
        this.compressedPackSize = compressedPackSize;
    }

    public void setHash(byte[] hash) {
        this.hash = hash;
    }

    public void setPremium(boolean premium) {
        this.premium = premium;
    }

    public void setType(ResourcePackType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourcePackDataInfoPacket)) {
            return false;
        }
        ResourcePackDataInfoPacket other = (ResourcePackDataInfoPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.maxChunkSize != other.maxChunkSize) {
            return false;
        }
        if (this.chunkCount != other.chunkCount) {
            return false;
        }
        if (this.compressedPackSize != other.compressedPackSize) {
            return false;
        }
        if (this.premium != other.premium) {
            return false;
        }
        UUID this$packId = this.packId;
        UUID other$packId = other.packId;
        if (this$packId == null ? other$packId != null : !((Object)this$packId).equals(other$packId)) {
            return false;
        }
        String this$packVersion = this.packVersion;
        String other$packVersion = other.packVersion;
        if (this$packVersion == null ? other$packVersion != null : !this$packVersion.equals(other$packVersion)) {
            return false;
        }
        if (!Arrays.equals(this.hash, other.hash)) {
            return false;
        }
        ResourcePackType this$type = this.type;
        ResourcePackType other$type = other.type;
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResourcePackDataInfoPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $maxChunkSize = this.maxChunkSize;
        result = result * 59 + (int)($maxChunkSize >>> 32 ^ $maxChunkSize);
        long $chunkCount = this.chunkCount;
        result = result * 59 + (int)($chunkCount >>> 32 ^ $chunkCount);
        long $compressedPackSize = this.compressedPackSize;
        result = result * 59 + (int)($compressedPackSize >>> 32 ^ $compressedPackSize);
        result = result * 59 + (this.premium ? 79 : 97);
        UUID $packId = this.packId;
        result = result * 59 + ($packId == null ? 43 : ((Object)$packId).hashCode());
        String $packVersion = this.packVersion;
        result = result * 59 + ($packVersion == null ? 43 : $packVersion.hashCode());
        result = result * 59 + Arrays.hashCode(this.hash);
        ResourcePackType $type = this.type;
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }

    public String toString() {
        return "ResourcePackDataInfoPacket(packId=" + this.packId + ", packVersion=" + this.packVersion + ", maxChunkSize=" + this.maxChunkSize + ", chunkCount=" + this.chunkCount + ", compressedPackSize=" + this.compressedPackSize + ", hash=" + Arrays.toString(this.hash) + ", premium=" + this.premium + ", type=" + (Object)((Object)this.type) + ")";
    }
}

