/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.scoreboard;

import java.util.Arrays;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.GeyserLogger;
import org.geysermc.geyser.scoreboard.Scoreboard;
import org.geysermc.geyser.scoreboard.ScoreboardUpdater;
import org.geysermc.geyser.scoreboard.Team;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.mcprotocollib.protocol.data.game.scoreboard.TeamAction;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.scoreboard.ClientboundSetPlayerTeamPacket;

@Translator(packet=ClientboundSetPlayerTeamPacket.class)
public class JavaSetPlayerTeamTranslator
extends PacketTranslator<ClientboundSetPlayerTeamPacket> {
    private final GeyserLogger logger = GeyserImpl.getInstance().getLogger();

    @Override
    public void translate(GeyserSession session, ClientboundSetPlayerTeamPacket packet) {
        if (this.logger.isDebug()) {
            this.logger.debug("Team packet " + packet.getTeamName() + " " + String.valueOf(packet.getAction()) + " " + Arrays.toString(packet.getPlayers()));
        }
        if ((packet.getAction() == TeamAction.ADD_PLAYER || packet.getAction() == TeamAction.REMOVE_PLAYER) && packet.getPlayers().length == 0) {
            return;
        }
        int pps = session.getWorldCache().increaseAndGetScoreboardPacketsPerSecond();
        Scoreboard scoreboard = session.getWorldCache().getScoreboard();
        if (packet.getAction() == TeamAction.CREATE) {
            scoreboard.registerNewTeam(packet.getTeamName(), packet.getPlayers(), packet.getDisplayName(), packet.getPrefix(), packet.getSuffix(), packet.getNameTagVisibility(), packet.getColor());
        } else {
            Team team = scoreboard.getTeam(packet.getTeamName());
            if (team == null) {
                if (this.logger.isDebug()) {
                    this.logger.debug("Error while translating Team Packet " + String.valueOf(packet.getAction()) + "! Scoreboard Team " + packet.getTeamName() + " is not registered.");
                }
                return;
            }
            switch (packet.getAction()) {
                case UPDATE: {
                    team.updateProperties(packet.getDisplayName(), packet.getPrefix(), packet.getSuffix(), packet.getNameTagVisibility(), packet.getColor());
                    break;
                }
                case ADD_PLAYER: {
                    team.addEntities(packet.getPlayers());
                    break;
                }
                case REMOVE_PLAYER: {
                    team.removeEntities(packet.getPlayers());
                    break;
                }
                case REMOVE: {
                    scoreboard.removeTeam(packet.getTeamName());
                }
            }
        }
        if (pps < ScoreboardUpdater.FIRST_SCORE_PACKETS_PER_SECOND_THRESHOLD) {
            scoreboard.onUpdate();
        }
    }
}

