/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntLinkedOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3i;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.inventory.BedrockContainerSlot;
import org.geysermc.geyser.inventory.CartographyContainer;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.PlayerInventory;
import org.geysermc.geyser.inventory.SlotType;
import org.geysermc.geyser.inventory.click.Click;
import org.geysermc.geyser.inventory.click.ClickPlan;
import org.geysermc.geyser.inventory.recipe.GeyserRecipe;
import org.geysermc.geyser.inventory.recipe.GeyserShapedRecipe;
import org.geysermc.geyser.inventory.recipe.GeyserShapelessRecipe;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.ContainerSlotType;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.FullContainerName;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.ItemStackRequest;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.ItemStackRequestSlotData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.AutoCraftRecipeAction;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.ConsumeAction;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.CraftResultsDeprecatedAction;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.DropAction;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.ItemStackRequestAction;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.ItemStackRequestActionType;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.SwapAction;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.TransferItemStackRequestAction;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.response.ItemStackResponse;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.response.ItemStackResponseContainer;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.response.ItemStackResponseSlot;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.response.ItemStackResponseStatus;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.ItemStackResponsePacket;
import org.geysermc.geyser.skin.FakeHeadProvider;
import org.geysermc.geyser.translator.inventory.AnvilInventoryTranslator;
import org.geysermc.geyser.translator.inventory.BeaconInventoryTranslator;
import org.geysermc.geyser.translator.inventory.BrewingInventoryTranslator;
import org.geysermc.geyser.translator.inventory.BundleInventoryTranslator;
import org.geysermc.geyser.translator.inventory.CartographyInventoryTranslator;
import org.geysermc.geyser.translator.inventory.CrafterInventoryTranslator;
import org.geysermc.geyser.translator.inventory.CraftingInventoryTranslator;
import org.geysermc.geyser.translator.inventory.EnchantingInventoryTranslator;
import org.geysermc.geyser.translator.inventory.Generic3X3InventoryTranslator;
import org.geysermc.geyser.translator.inventory.GrindstoneInventoryTranslator;
import org.geysermc.geyser.translator.inventory.HopperInventoryTranslator;
import org.geysermc.geyser.translator.inventory.LecternInventoryTranslator;
import org.geysermc.geyser.translator.inventory.LoomInventoryTranslator;
import org.geysermc.geyser.translator.inventory.MerchantInventoryTranslator;
import org.geysermc.geyser.translator.inventory.PlayerInventoryTranslator;
import org.geysermc.geyser.translator.inventory.ShulkerInventoryTranslator;
import org.geysermc.geyser.translator.inventory.SmithingInventoryTranslator;
import org.geysermc.geyser.translator.inventory.StonecutterInventoryTranslator;
import org.geysermc.geyser.translator.inventory.chest.DoubleChestInventoryTranslator;
import org.geysermc.geyser.translator.inventory.chest.SingleChestInventoryTranslator;
import org.geysermc.geyser.translator.inventory.furnace.BlastFurnaceInventoryTranslator;
import org.geysermc.geyser.translator.inventory.furnace.FurnaceInventoryTranslator;
import org.geysermc.geyser.translator.inventory.furnace.SmokerInventoryTranslator;
import org.geysermc.geyser.util.InventoryUtils;
import org.geysermc.geyser.util.ItemUtils;
import org.geysermc.mcprotocollib.protocol.data.game.inventory.ContainerType;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.recipe.display.slot.EmptySlotDisplay;
import org.geysermc.mcprotocollib.protocol.data.game.recipe.display.slot.SlotDisplay;

public abstract class InventoryTranslator<Type extends Inventory> {
    public static final InventoryTranslator<PlayerInventory> PLAYER_INVENTORY_TRANSLATOR = new PlayerInventoryTranslator();
    private static final Map<ContainerType, InventoryTranslator<? extends Inventory>> INVENTORY_TRANSLATORS = new EnumMap<ContainerType, InventoryTranslator<? extends Inventory>>(ContainerType.class){
        {
            this.put(ContainerType.GENERIC_9X1, new SingleChestInventoryTranslator(9));
            this.put(ContainerType.GENERIC_9X2, new SingleChestInventoryTranslator(18));
            this.put(ContainerType.GENERIC_9X3, new SingleChestInventoryTranslator(27));
            this.put(ContainerType.GENERIC_9X4, new DoubleChestInventoryTranslator(36));
            this.put(ContainerType.GENERIC_9X5, new DoubleChestInventoryTranslator(45));
            this.put(ContainerType.GENERIC_9X6, new DoubleChestInventoryTranslator(54));
            this.put(ContainerType.FURNACE, new FurnaceInventoryTranslator());
            this.put(ContainerType.BLAST_FURNACE, new BlastFurnaceInventoryTranslator());
            this.put(ContainerType.SMOKER, new SmokerInventoryTranslator());
            this.put(ContainerType.ANVIL, new AnvilInventoryTranslator());
            this.put(ContainerType.BEACON, new BeaconInventoryTranslator());
            this.put(ContainerType.BREWING_STAND, new BrewingInventoryTranslator());
            this.put(ContainerType.CARTOGRAPHY, new CartographyInventoryTranslator());
            this.put(ContainerType.CRAFTER_3x3, new CrafterInventoryTranslator());
            this.put(ContainerType.CRAFTING, new CraftingInventoryTranslator());
            this.put(ContainerType.ENCHANTMENT, new EnchantingInventoryTranslator());
            this.put(ContainerType.HOPPER, new HopperInventoryTranslator());
            this.put(ContainerType.GENERIC_3X3, new Generic3X3InventoryTranslator());
            this.put(ContainerType.GRINDSTONE, new GrindstoneInventoryTranslator());
            this.put(ContainerType.LOOM, new LoomInventoryTranslator());
            this.put(ContainerType.MERCHANT, new MerchantInventoryTranslator());
            this.put(ContainerType.SHULKER_BOX, new ShulkerInventoryTranslator());
            this.put(ContainerType.SMITHING, new SmithingInventoryTranslator());
            this.put(ContainerType.STONECUTTER, new StonecutterInventoryTranslator());
            this.put(ContainerType.LECTERN, new LecternInventoryTranslator());
        }
    };
    public static final int PLAYER_INVENTORY_SIZE = 36;
    public static final int PLAYER_INVENTORY_OFFSET = 9;
    public final int size;

    public boolean requiresOpeningDelay(GeyserSession session, Type inventory) {
        return false;
    }

    public boolean canReuseInventory(GeyserSession session, @NonNull Inventory inventory, @NonNull Inventory previous) {
        if (inventory.getContainerType() == null || previous.getContainerType() == null || !Objects.equals((Object)inventory.getContainerType(), (Object)previous.getContainerType()) || !Objects.equals(inventory.getTitle(), previous.getTitle()) || inventory.getSize() != previous.getSize()) {
            return false;
        }
        return previous.getHolderId() != -1L || previous.getHolderPosition() != Vector3i.ZERO;
    }

    public abstract boolean prepareInventory(GeyserSession var1, Type var2);

    public abstract void openInventory(GeyserSession var1, Type var2);

    public abstract void closeInventory(GeyserSession var1, Type var2, boolean var3);

    public abstract void updateProperty(GeyserSession var1, Type var2, int var3, int var4);

    public abstract void updateInventory(GeyserSession var1, Type var2);

    public abstract void updateSlot(GeyserSession var1, Type var2, int var3);

    public abstract int bedrockSlotToJava(ItemStackRequestSlotData var1);

    public abstract int javaSlotToBedrock(int var1);

    public abstract BedrockContainerSlot javaSlotToBedrockContainer(int var1, Type var2);

    public abstract SlotType getSlotType(int var1);

    public abstract Type createInventory(GeyserSession var1, String var2, int var3, ContainerType var4);

    public int getGridSize() {
        return -1;
    }

    protected boolean shouldRejectItemPlace(GeyserSession session, Type inventory, ContainerSlotType bedrockSourceContainer, int javaSourceSlot, ContainerSlotType bedrockDestinationContainer, int javaDestinationSlot) {
        return false;
    }

    protected boolean shouldHandleRequestFirst(ItemStackRequestAction action, Type inventory) {
        return false;
    }

    protected ItemStackResponse translateSpecialRequest(GeyserSession session, Type inventory, ItemStackRequest request) {
        return InventoryTranslator.rejectRequest(request);
    }

    public final void translateRequests(GeyserSession session, Type inventory, List<ItemStackRequest> requests) {
        boolean refresh = false;
        ItemStackResponsePacket responsePacket = new ItemStackResponsePacket();
        for (ItemStackRequest request : requests) {
            ItemStackResponse response;
            if (request.getActions().length > 0) {
                ItemStackRequestAction firstAction = request.getActions()[0];
                if (this.shouldHandleRequestFirst(firstAction, inventory)) {
                    response = this.translateSpecialRequest(session, inventory, request);
                } else {
                    response = switch (firstAction.getType()) {
                        case ItemStackRequestActionType.CRAFT_RECIPE -> this.translateCraftingRequest(session, inventory, request);
                        case ItemStackRequestActionType.CRAFT_RECIPE_AUTO -> this.translateAutoCraftingRequest(session, inventory, request);
                        case ItemStackRequestActionType.CRAFT_CREATIVE -> this.translateCreativeRequest(session, inventory, request);
                        default -> this.translateRequest(session, inventory, request);
                    };
                }
            } else {
                response = InventoryTranslator.rejectRequest(request);
            }
            if (response.getResult() != ItemStackResponseStatus.OK) {
                refresh = true;
            }
            responsePacket.getEntries().add(response);
        }
        session.sendUpstreamPacket(responsePacket);
        if (refresh) {
            InventoryUtils.updateCursor(session);
            this.updateInventory(session, inventory);
        }
        ((Inventory)inventory).resetNextStateId();
    }

    public ItemStackResponse translateRequest(GeyserSession session, Type inventory, ItemStackRequest request) {
        ClickPlan plan = new ClickPlan(session, this, (Inventory)inventory);
        IntOpenHashSet affectedSlots = new IntOpenHashSet();
        int pendingOutput = 0;
        int savedTempSlot = -1;
        block7: for (ItemStackRequestAction action : request.getActions()) {
            GeyserItemStack cursor = session.getPlayerInventory().getCursor();
            switch (action.getType()) {
                case TAKE: 
                case PLACE: {
                    TransferItemStackRequestAction transferAction = (TransferItemStackRequestAction)action;
                    if (!this.checkNetId(session, inventory, transferAction.getSource()) || !this.checkNetId(session, inventory, transferAction.getDestination())) {
                        if (session.getGeyser().getConfig().isDebugMode()) {
                            session.getGeyser().getLogger().error("DEBUG: About to reject TAKE/PLACE request made by " + session.bedrockUsername());
                            this.dumpStackRequestDetails(session, inventory, transferAction.getSource(), transferAction.getDestination());
                        }
                        return InventoryTranslator.rejectRequest(request);
                    }
                    ItemStackResponse bundleResponse = BundleInventoryTranslator.handleBundle(session, this, inventory, request, false);
                    if (bundleResponse != null) {
                        return bundleResponse;
                    }
                    int sourceSlot = this.bedrockSlotToJava(transferAction.getSource());
                    int destSlot = this.bedrockSlotToJava(transferAction.getDestination());
                    boolean isSourceCursor = InventoryTranslator.isCursor(transferAction.getSource());
                    boolean isDestCursor = InventoryTranslator.isCursor(transferAction.getDestination());
                    if (this instanceof PlayerInventoryTranslator) {
                        if (destSlot == 5) {
                            GeyserItemStack javaItem = ((Inventory)inventory).getItem(sourceSlot);
                            if (javaItem.asItem() == Items.PLAYER_HEAD && javaItem.hasNonBaseComponents()) {
                                FakeHeadProvider.setHead(session, session.getPlayerEntity(), javaItem.getComponent(DataComponentTypes.PROFILE));
                            }
                        } else if (sourceSlot == 5) {
                            FakeHeadProvider.restoreOriginalSkin(session, session.getPlayerEntity());
                        }
                    }
                    if (this.shouldRejectItemPlace(session, inventory, transferAction.getSource().getContainerName().getContainer(), isSourceCursor ? -1 : sourceSlot, transferAction.getDestination().getContainerName().getContainer(), isDestCursor ? -1 : destSlot)) {
                        return InventoryTranslator.rejectRequest(request, false);
                    }
                    if (pendingOutput == 0 && !isSourceCursor && this.getSlotType(sourceSlot) == SlotType.OUTPUT && transferAction.getCount() < plan.getItem(sourceSlot).getAmount()) {
                        if (isDestCursor) {
                            return InventoryTranslator.rejectRequest(request);
                        }
                        if (!plan.getCursor().isEmpty()) {
                            savedTempSlot = InventoryTranslator.findTempSlot(plan, plan.getCursor(), true, new int[0]);
                            if (savedTempSlot == -1) {
                                return InventoryTranslator.rejectRequest(request);
                            }
                            plan.add(Click.LEFT, savedTempSlot);
                        }
                        pendingOutput = plan.getItem(sourceSlot).getAmount();
                        plan.add(Click.LEFT, sourceSlot);
                    }
                    if (pendingOutput > 0) {
                        if (isSourceCursor || this.getSlotType(sourceSlot) != SlotType.OUTPUT || transferAction.getCount() > pendingOutput || destSlot == savedTempSlot || isDestCursor) {
                            return InventoryTranslator.rejectRequest(request);
                        }
                        GeyserItemStack destItem = plan.getItem(destSlot);
                        if (!destItem.isEmpty() && !InventoryUtils.canStack(destItem, plan.getCursor())) {
                            return InventoryTranslator.rejectRequest(request);
                        }
                        if (pendingOutput == transferAction.getCount()) {
                            plan.add(Click.LEFT, destSlot);
                        } else {
                            for (int i = 0; i < transferAction.getCount(); ++i) {
                                plan.add(Click.RIGHT, destSlot);
                            }
                        }
                        if ((pendingOutput -= transferAction.getCount()) != plan.getCursor().getAmount()) {
                            return InventoryTranslator.rejectRequest(request);
                        }
                        if (pendingOutput != 0 || savedTempSlot == -1) continue block7;
                        plan.add(Click.LEFT, savedTempSlot);
                        savedTempSlot = -1;
                        continue block7;
                    }
                    if (isSourceCursor && isDestCursor) {
                        return InventoryTranslator.rejectRequest(request);
                    }
                    if (isSourceCursor) {
                        int sourceAmount = cursor.getAmount();
                        if (transferAction.getCount() == sourceAmount) {
                            plan.add(Click.LEFT, destSlot);
                            continue block7;
                        }
                        for (int i = 0; i < transferAction.getCount(); ++i) {
                            plan.add(Click.RIGHT, destSlot);
                        }
                        continue block7;
                    }
                    if (isDestCursor) {
                        GeyserItemStack sourceItem = plan.getItem(sourceSlot);
                        int sourceAmount = sourceItem.getAmount();
                        if (cursor.isEmpty()) {
                            if (transferAction.getCount() == sourceAmount) {
                                plan.add(Click.LEFT, sourceSlot);
                                continue block7;
                            }
                            if (transferAction.getCount() == sourceAmount - sourceAmount / 2) {
                                plan.add(Click.RIGHT, sourceSlot);
                                continue block7;
                            }
                            plan.add(Click.LEFT, sourceSlot);
                            for (int i = 0; i < sourceAmount - transferAction.getCount(); ++i) {
                                plan.add(Click.RIGHT, sourceSlot);
                            }
                            continue block7;
                        }
                        if (!InventoryUtils.canStack(cursor, plan.getItem(sourceSlot))) {
                            return InventoryTranslator.rejectRequest(request);
                        }
                        if (transferAction.getCount() != sourceAmount) {
                            int tempSlot = InventoryTranslator.findTempSlot(plan, cursor, false, sourceSlot);
                            if (tempSlot == -1) {
                                return InventoryTranslator.rejectRequest(request);
                            }
                            plan.add(Click.LEFT, tempSlot);
                            plan.add(Click.LEFT, sourceSlot);
                            for (int i = 0; i < transferAction.getCount(); ++i) {
                                plan.add(Click.RIGHT, tempSlot);
                            }
                            plan.add(Click.LEFT, sourceSlot);
                            plan.add(Click.LEFT, tempSlot);
                            continue block7;
                        }
                        if (this.getSlotType(sourceSlot).equals((Object)SlotType.NORMAL)) {
                            plan.add(Click.LEFT, sourceSlot);
                        }
                        plan.add(Click.LEFT, sourceSlot);
                        continue block7;
                    }
                    int tempSlot = -1;
                    if (!plan.getCursor().isEmpty()) {
                        tempSlot = InventoryTranslator.findTempSlot(plan, cursor, this.getSlotType(sourceSlot) != SlotType.NORMAL, sourceSlot, destSlot);
                        if (tempSlot == -1) {
                            return InventoryTranslator.rejectRequest(request);
                        }
                        plan.add(Click.LEFT, tempSlot);
                    }
                    this.transferSlot(plan, sourceSlot, destSlot, transferAction.getCount());
                    if (tempSlot == -1) continue block7;
                    plan.add(Click.LEFT, tempSlot);
                    continue block7;
                }
                case SWAP: {
                    Click click;
                    SwapAction swapAction = (SwapAction)action;
                    ItemStackRequestSlotData source = swapAction.getSource();
                    ItemStackRequestSlotData destination = swapAction.getDestination();
                    if (!this.checkNetId(session, inventory, source) || !this.checkNetId(session, inventory, destination)) {
                        if (session.getGeyser().getConfig().isDebugMode()) {
                            session.getGeyser().getLogger().error("DEBUG: About to reject SWAP request made by " + session.bedrockUsername());
                            this.dumpStackRequestDetails(session, inventory, source, destination);
                        }
                        return InventoryTranslator.rejectRequest(request);
                    }
                    int sourceSlot = this.bedrockSlotToJava(source);
                    int destSlot = this.bedrockSlotToJava(destination);
                    boolean isSourceCursor = InventoryTranslator.isCursor(source);
                    boolean isDestCursor = InventoryTranslator.isCursor(destination);
                    if (this.shouldRejectItemPlace(session, inventory, source.getContainerName().getContainer(), isSourceCursor ? -1 : sourceSlot, destination.getContainerName().getContainer(), isDestCursor ? -1 : destSlot)) {
                        return InventoryTranslator.rejectRequest(request, false);
                    }
                    if ((!isSourceCursor && destination.getContainerName().getContainer() == ContainerSlotType.HOTBAR || destination.getContainerName().getContainer() == ContainerSlotType.HOTBAR_AND_INVENTORY) && (click = InventoryUtils.getClickForHotbarSwap(destination.getSlot())) != null) {
                        plan.add(click, sourceSlot);
                        continue block7;
                    }
                    if (isSourceCursor && isDestCursor) {
                        return InventoryTranslator.rejectRequest(request);
                    }
                    if (isSourceCursor) {
                        if (InventoryUtils.canStack(cursor, plan.getItem(destSlot))) {
                            return InventoryTranslator.rejectRequest(request);
                        }
                        plan.add(BundleInventoryTranslator.isBundle(plan, destSlot) || BundleInventoryTranslator.isBundle(cursor) ? Click.RIGHT : Click.LEFT, destSlot);
                        continue block7;
                    }
                    if (isDestCursor) {
                        if (InventoryUtils.canStack(cursor, plan.getItem(sourceSlot))) {
                            return InventoryTranslator.rejectRequest(request);
                        }
                        plan.add(BundleInventoryTranslator.isBundle(plan, sourceSlot) || BundleInventoryTranslator.isBundle(cursor) ? Click.RIGHT : Click.LEFT, sourceSlot);
                        continue block7;
                    }
                    if (!cursor.isEmpty()) {
                        return InventoryTranslator.rejectRequest(request);
                    }
                    if (sourceSlot == destSlot) {
                        return InventoryTranslator.rejectRequest(request);
                    }
                    if (InventoryUtils.canStack(plan.getItem(sourceSlot), plan.getItem(destSlot))) {
                        return InventoryTranslator.rejectRequest(request);
                    }
                    plan.add(Click.LEFT, sourceSlot);
                    plan.add(BundleInventoryTranslator.isBundle(plan, sourceSlot) || BundleInventoryTranslator.isBundle(plan, destSlot) ? Click.RIGHT : Click.LEFT, destSlot);
                    plan.add(Click.LEFT, sourceSlot);
                    continue block7;
                }
                case DROP: {
                    DropAction dropAction = (DropAction)action;
                    if (!this.checkNetId(session, inventory, dropAction.getSource())) {
                        return InventoryTranslator.rejectRequest(request);
                    }
                    if (InventoryTranslator.isCursor(dropAction.getSource())) {
                        int sourceAmount = plan.getCursor().getAmount();
                        if (dropAction.getCount() == sourceAmount) {
                            plan.add(Click.LEFT_OUTSIDE, -999);
                            continue block7;
                        }
                        for (int i = 0; i < dropAction.getCount(); ++i) {
                            plan.add(Click.RIGHT_OUTSIDE, -999);
                        }
                        continue block7;
                    }
                    int sourceSlot = this.bedrockSlotToJava(dropAction.getSource());
                    int sourceAmount = plan.getItem(sourceSlot).getAmount();
                    if (dropAction.getCount() == sourceAmount && sourceAmount > 1) {
                        plan.add(Click.DROP_ALL, sourceSlot);
                        continue block7;
                    }
                    for (int i = 0; i < dropAction.getCount(); ++i) {
                        plan.add(Click.DROP_ONE, sourceSlot);
                    }
                    continue block7;
                }
                case CONSUME: {
                    if (!(inventory instanceof CartographyContainer)) continue block7;
                    ConsumeAction consumeData = (ConsumeAction)action;
                    int sourceSlot = this.bedrockSlotToJava(consumeData.getSource());
                    if (sourceSlot == 0 && ((Inventory)inventory).getItem(1).isEmpty() || sourceSlot == 1 && ((Inventory)inventory).getItem(0).isEmpty()) {
                        return InventoryTranslator.rejectRequest(request, false);
                    }
                    if (sourceSlot == 1) {
                        GeyserItemStack item = ((Inventory)inventory).getItem(sourceSlot);
                        item.setAmount(item.getAmount() - consumeData.getCount());
                        if (item.isEmpty()) {
                            ((Inventory)inventory).setItem(sourceSlot, GeyserItemStack.EMPTY, session);
                        }
                        GeyserItemStack itemZero = ((Inventory)inventory).getItem(0);
                        itemZero.setAmount(itemZero.getAmount() - consumeData.getCount());
                        if (itemZero.isEmpty()) {
                            ((Inventory)inventory).setItem(0, GeyserItemStack.EMPTY, session);
                        }
                    }
                    affectedSlots.add(sourceSlot);
                    continue block7;
                }
                case CRAFT_RECIPE: 
                case CRAFT_RECIPE_AUTO: 
                case CRAFT_NON_IMPLEMENTED_DEPRECATED: 
                case CRAFT_RESULTS_DEPRECATED: 
                case CRAFT_RECIPE_OPTIONAL: 
                case CRAFT_LOOM: 
                case CRAFT_REPAIR_AND_DISENCHANT: {
                    continue block7;
                }
                default: {
                    return InventoryTranslator.rejectRequest(request);
                }
            }
        }
        if (pendingOutput != 0) {
            return InventoryTranslator.rejectRequest(request);
        }
        plan.execute(false);
        affectedSlots.addAll((IntCollection)plan.getAffectedSlots());
        return InventoryTranslator.acceptRequest(request, this.makeContainerEntries(session, inventory, (IntSet)affectedSlots));
    }

    public ItemStackResponse translateCraftingRequest(GeyserSession session, Type inventory, ItemStackRequest request) {
        int resultSize = 0;
        CraftState craftState = CraftState.START;
        int leftover = 0;
        ClickPlan plan = new ClickPlan(session, this, (Inventory)inventory);
        IntOpenHashSet affectedSlots = new IntOpenHashSet();
        block6: for (ItemStackRequestAction action : request.getActions()) {
            switch (action.getType()) {
                case CRAFT_RECIPE: {
                    if (craftState != CraftState.START) {
                        return InventoryTranslator.rejectRequest(request);
                    }
                    craftState = CraftState.RECIPE_ID;
                    continue block6;
                }
                case CRAFT_RESULTS_DEPRECATED: {
                    CraftResultsDeprecatedAction deprecatedCraftAction = (CraftResultsDeprecatedAction)action;
                    if (craftState != CraftState.RECIPE_ID) {
                        return InventoryTranslator.rejectRequest(request);
                    }
                    craftState = CraftState.DEPRECATED;
                    if (deprecatedCraftAction.getResultItems().length != 1) {
                        return InventoryTranslator.rejectRequest(request);
                    }
                    resultSize = deprecatedCraftAction.getResultItems()[0].getCount();
                    int timesCrafted = deprecatedCraftAction.getTimesCrafted();
                    if (resultSize > 0 && timesCrafted > 0) continue block6;
                    return InventoryTranslator.rejectRequest(request);
                }
                case CONSUME: {
                    if (craftState != CraftState.DEPRECATED && craftState != CraftState.INGREDIENTS) {
                        return InventoryTranslator.rejectRequest(request);
                    }
                    craftState = CraftState.INGREDIENTS;
                    affectedSlots.add(this.bedrockSlotToJava(((ConsumeAction)action).getSource()));
                    continue block6;
                }
                case TAKE: 
                case PLACE: {
                    int i;
                    TransferItemStackRequestAction transferAction = (TransferItemStackRequestAction)action;
                    if (craftState != CraftState.INGREDIENTS && craftState != CraftState.TRANSFER) {
                        return InventoryTranslator.rejectRequest(request);
                    }
                    craftState = CraftState.TRANSFER;
                    if (transferAction.getSource().getContainerName().getContainer() != ContainerSlotType.CREATED_OUTPUT) {
                        return InventoryTranslator.rejectRequest(request);
                    }
                    if (transferAction.getCount() <= 0) {
                        return InventoryTranslator.rejectRequest(request);
                    }
                    int sourceSlot = this.bedrockSlotToJava(transferAction.getSource());
                    int destSlot = this.bedrockSlotToJava(transferAction.getDestination());
                    if (InventoryTranslator.isCursor(transferAction.getDestination())) {
                        plan.add(Click.LEFT, sourceSlot);
                        craftState = CraftState.DONE;
                        continue block6;
                    }
                    if (leftover != 0) {
                        if (transferAction.getCount() > leftover) {
                            return InventoryTranslator.rejectRequest(request);
                        }
                        if (transferAction.getCount() == leftover) {
                            plan.add(Click.LEFT, destSlot);
                        } else {
                            for (int i2 = 0; i2 < transferAction.getCount(); ++i2) {
                                plan.add(Click.RIGHT, destSlot);
                            }
                        }
                        leftover -= transferAction.getCount();
                        continue block6;
                    }
                    int remainder = transferAction.getCount() % resultSize;
                    int timesToCraft = transferAction.getCount() / resultSize;
                    if (plan.getCursor().isEmpty()) {
                        for (i = 0; i < timesToCraft; ++i) {
                            plan.add(Click.LEFT, sourceSlot);
                            plan.add(Click.LEFT, destSlot);
                        }
                    } else {
                        GeyserItemStack cursor = session.getPlayerInventory().getCursor();
                        int tempSlot = InventoryTranslator.findTempSlot(plan, cursor, true, sourceSlot, destSlot);
                        if (tempSlot == -1) {
                            return InventoryTranslator.rejectRequest(request);
                        }
                        plan.add(Click.LEFT, tempSlot);
                        for (int i3 = 0; i3 < timesToCraft; ++i3) {
                            plan.add(Click.LEFT, sourceSlot);
                            plan.add(Click.LEFT, destSlot);
                        }
                        plan.add(Click.LEFT, tempSlot);
                    }
                    if (remainder <= 0) continue block6;
                    plan.add(Click.LEFT, 0);
                    for (i = 0; i < remainder; ++i) {
                        plan.add(Click.RIGHT, destSlot);
                    }
                    leftover = resultSize - remainder;
                    continue block6;
                }
                default: {
                    return InventoryTranslator.rejectRequest(request);
                }
            }
        }
        plan.execute(false);
        affectedSlots.addAll((IntCollection)plan.getAffectedSlots());
        return InventoryTranslator.acceptRequest(request, this.makeContainerEntries(session, inventory, (IntSet)affectedSlots));
    }

    public ItemStackResponse translateAutoCraftingRequest(GeyserSession session, Type inventory, ItemStackRequest request) {
        int gridSize = this.getGridSize();
        if (gridSize == -1) {
            return InventoryTranslator.rejectRequest(request);
        }
        int gridDimensions = gridSize == 4 ? 2 : 3;
        List<Object> ingredients = Collections.emptyList();
        SlotDisplay output = null;
        int recipeWidth = 0;
        int ingRemaining = 0;
        int ingredientIndex = -1;
        Int2IntOpenHashMap consumedSlots = new Int2IntOpenHashMap();
        int prioritySlot = -1;
        int timesCrafted = 0;
        Int2ObjectOpenHashMap ingredientMap = new Int2ObjectOpenHashMap();
        CraftState craftState = CraftState.START;
        ClickPlan plan = new ClickPlan(session, this, (Inventory)inventory);
        block6: for (ItemStackRequestAction action : request.getActions()) {
            switch (action.getType()) {
                case CRAFT_RECIPE_AUTO: {
                    AutoCraftRecipeAction autoCraftAction = (AutoCraftRecipeAction)action;
                    if (craftState != CraftState.START) {
                        return InventoryTranslator.rejectRequest(request);
                    }
                    craftState = CraftState.RECIPE_ID;
                    int recipeId = autoCraftAction.getRecipeNetworkId();
                    GeyserRecipe recipe = (GeyserRecipe)session.getCraftingRecipes().get(recipeId);
                    if (recipe == null) {
                        return InventoryTranslator.rejectRequest(request);
                    }
                    if (!plan.getCursor().isEmpty()) {
                        return InventoryTranslator.rejectRequest(request);
                    }
                    for (int i = 1; i <= gridSize; ++i) {
                        if (((Inventory)inventory).getItem(i).isEmpty()) continue;
                        return InventoryTranslator.rejectRequest(request);
                    }
                    if (recipe.isShaped()) {
                        GeyserShapedRecipe shapedRecipe = (GeyserShapedRecipe)recipe;
                        ingredients = shapedRecipe.ingredients();
                        recipeWidth = shapedRecipe.width();
                        output = shapedRecipe.result();
                        if (recipeWidth <= gridDimensions && shapedRecipe.height() <= gridDimensions) continue block6;
                        return InventoryTranslator.rejectRequest(request);
                    }
                    GeyserShapelessRecipe shapelessRecipe = (GeyserShapelessRecipe)recipe;
                    ingredients = shapelessRecipe.ingredients();
                    recipeWidth = gridDimensions;
                    output = shapelessRecipe.result();
                    if (ingredients.size() <= gridSize) continue block6;
                    return InventoryTranslator.rejectRequest(request);
                }
                case CRAFT_RESULTS_DEPRECATED: {
                    CraftResultsDeprecatedAction deprecatedCraftAction = (CraftResultsDeprecatedAction)action;
                    if (craftState != CraftState.RECIPE_ID) {
                        return InventoryTranslator.rejectRequest(request);
                    }
                    craftState = CraftState.DEPRECATED;
                    if (deprecatedCraftAction.getResultItems().length != 1) {
                        return InventoryTranslator.rejectRequest(request);
                    }
                    int resultSize = deprecatedCraftAction.getResultItems()[0].getCount();
                    timesCrafted = deprecatedCraftAction.getTimesCrafted();
                    if (resultSize > 0 && timesCrafted > 0) continue block6;
                    return InventoryTranslator.rejectRequest(request);
                }
                case CONSUME: {
                    ConsumeAction consumeAction = (ConsumeAction)action;
                    if (craftState != CraftState.DEPRECATED && craftState != CraftState.INGREDIENTS) {
                        return InventoryTranslator.rejectRequest(request);
                    }
                    craftState = CraftState.INGREDIENTS;
                    if (ingRemaining == 0) {
                        while (++ingredientIndex < ingredients.size()) {
                            if (ingredients.get(ingredientIndex) instanceof EmptySlotDisplay) continue;
                            ingRemaining = timesCrafted;
                            break;
                        }
                    }
                    if ((ingRemaining -= consumeAction.getCount()) < 0) {
                        return InventoryTranslator.rejectRequest(request);
                    }
                    int javaSlot = this.bedrockSlotToJava(consumeAction.getSource());
                    consumedSlots.merge(javaSlot, consumeAction.getCount(), Integer::sum);
                    int gridSlot = 1 + ingredientIndex + ingredientIndex / recipeWidth * (gridDimensions - recipeWidth);
                    Int2IntMap sources = (Int2IntMap)ingredientMap.computeIfAbsent(gridSlot, k -> new Int2IntOpenHashMap());
                    sources.put(javaSlot, consumeAction.getCount());
                    continue block6;
                }
                case TAKE: 
                case PLACE: {
                    TransferItemStackRequestAction transferAction = (TransferItemStackRequestAction)action;
                    if (craftState != CraftState.INGREDIENTS && craftState != CraftState.TRANSFER) {
                        return InventoryTranslator.rejectRequest(request);
                    }
                    craftState = CraftState.TRANSFER;
                    if (transferAction.getSource().getContainerName().getContainer() != ContainerSlotType.CREATED_OUTPUT) {
                        return InventoryTranslator.rejectRequest(request);
                    }
                    if (transferAction.getCount() <= 0) {
                        return InventoryTranslator.rejectRequest(request);
                    }
                    int javaSlot = this.bedrockSlotToJava(transferAction.getDestination());
                    if (InventoryTranslator.isCursor(transferAction.getDestination())) {
                        int tempSlot;
                        if (timesCrafted <= 1 || (tempSlot = InventoryTranslator.findTempSlot(plan, GeyserItemStack.from(output), true, new int[0])) != -1) break block6;
                        return InventoryTranslator.rejectRequest(request);
                    }
                    if (((Inventory)inventory).getItem(javaSlot).getAmount() != consumedSlots.get(javaSlot)) continue block6;
                    prioritySlot = this.bedrockSlotToJava(transferAction.getDestination());
                    break block6;
                }
                default: {
                    return InventoryTranslator.rejectRequest(request);
                }
            }
        }
        int maxLoops = Math.min(64, timesCrafted);
        for (int loops = 0; loops < maxLoops; ++loops) {
            boolean done = true;
            for (Int2ObjectMap.Entry entry : ingredientMap.int2ObjectEntrySet()) {
                Int2IntMap sources = (Int2IntMap)entry.getValue();
                if (sources.isEmpty()) continue;
                done = false;
                int gridSlot = entry.getIntKey();
                if (!plan.getItem(gridSlot).isEmpty()) continue;
                int sourceSlot = loops == 0 && sources.containsKey(prioritySlot) ? prioritySlot : sources.keySet().iterator().nextInt();
                int transferAmount = sources.remove(sourceSlot);
                this.transferSlot(plan, sourceSlot, gridSlot, transferAmount);
            }
            if (done) break;
            plan.add(Click.LEFT_SHIFT, 0, true);
        }
        ((Inventory)inventory).setItem(0, GeyserItemStack.from(output), session);
        plan.execute(true);
        return InventoryTranslator.acceptRequest(request, this.makeContainerEntries(session, inventory, plan.getAffectedSlots()));
    }

    protected ItemStackResponse translateCreativeRequest(GeyserSession session, Type inventory, ItemStackRequest request) {
        return InventoryTranslator.rejectRequest(request);
    }

    private void transferSlot(ClickPlan plan, int sourceSlot, int destSlot, int transferAmount) {
        boolean tempSwap = !plan.getCursor().isEmpty();
        int sourceAmount = plan.getItem(sourceSlot).getAmount();
        if (transferAmount == sourceAmount) {
            plan.add(Click.LEFT, sourceSlot);
            plan.add(Click.LEFT, destSlot);
        } else {
            int holding;
            int halfSource = sourceAmount - sourceAmount / 2;
            if (!tempSwap && transferAmount <= halfSource) {
                plan.add(Click.RIGHT, sourceSlot);
                holding = halfSource;
            } else {
                plan.add(Click.LEFT, sourceSlot);
                holding = sourceAmount;
            }
            if (!tempSwap && transferAmount > holding / 2) {
                for (int i = 0; i < holding - transferAmount; ++i) {
                    plan.add(Click.RIGHT, sourceSlot);
                }
                plan.add(Click.LEFT, destSlot);
            } else {
                for (int i = 0; i < transferAmount; ++i) {
                    plan.add(Click.RIGHT, destSlot);
                }
                plan.add(Click.LEFT, sourceSlot);
            }
        }
    }

    protected static ItemStackResponse acceptRequest(ItemStackRequest request, List<ItemStackResponseContainer> containerEntries) {
        return new ItemStackResponse(ItemStackResponseStatus.OK, request.getRequestId(), containerEntries);
    }

    protected static ItemStackResponse rejectRequest(ItemStackRequest request) {
        return InventoryTranslator.rejectRequest(request, true);
    }

    protected static ItemStackResponse rejectRequest(ItemStackRequest request, boolean throwError) {
        if (throwError && GeyserImpl.getInstance().getConfig().isDebugMode()) {
            new Throwable("DEBUGGING: ItemStackRequest rejected " + request.toString()).printStackTrace();
        }
        return new ItemStackResponse(ItemStackResponseStatus.ERROR, request.getRequestId(), Collections.emptyList());
    }

    protected void dumpStackRequestDetails(GeyserSession session, Type inventory, ItemStackRequestSlotData source, ItemStackRequestSlotData destination) {
        session.getGeyser().getLogger().error("Source: " + source.toString() + " Result: " + this.checkNetId(session, inventory, source));
        session.getGeyser().getLogger().error("Destination: " + destination.toString() + " Result: " + this.checkNetId(session, inventory, destination));
        session.getGeyser().getLogger().error("Geyser's record of source slot: " + String.valueOf(((Inventory)inventory).getItem(this.bedrockSlotToJava(source))));
        session.getGeyser().getLogger().error("Geyser's record of destination slot: " + String.valueOf(((Inventory)inventory).getItem(this.bedrockSlotToJava(destination))));
    }

    public boolean checkNetId(GeyserSession session, Type inventory, ItemStackRequestSlotData slotInfoData) {
        if (BundleInventoryTranslator.isBundle(slotInfoData)) {
            return true;
        }
        int netId = slotInfoData.getStackNetworkId();
        if (netId < 0 || netId == 1) {
            return true;
        }
        GeyserItemStack currentItem = InventoryTranslator.isCursor(slotInfoData) ? session.getPlayerInventory().getCursor() : ((Inventory)inventory).getItem(this.bedrockSlotToJava(slotInfoData));
        return currentItem.getNetId() == netId;
    }

    private static int findTempSlot(ClickPlan plan, GeyserItemStack item, boolean emptyOnly, int ... slotBlacklist) {
        int slot;
        int i;
        IntLinkedOpenHashSet potentialSlots = new IntLinkedOpenHashSet(36);
        int hotbarOffset = plan.getInventory().getOffsetForHotbar(0);
        for (i = hotbarOffset - 1; i >= hotbarOffset - 27; --i) {
            potentialSlots.add(i);
        }
        for (i = hotbarOffset + 8; i >= hotbarOffset; --i) {
            potentialSlots.add(i);
        }
        for (int i2 : slotBlacklist) {
            potentialSlots.remove(i2);
        }
        IntBidirectionalIterator it = potentialSlots.iterator();
        while (it.hasNext()) {
            slot = it.nextInt();
            if (!plan.isEmpty(slot)) continue;
            return slot;
        }
        if (emptyOnly) {
            return -1;
        }
        it = potentialSlots.iterator();
        block4: while (it.hasNext()) {
            slot = it.nextInt();
            if (plan.canStack(slot, item)) continue;
            for (int blacklistedSlot : slotBlacklist) {
                GeyserItemStack blacklistedItem = plan.getItem(blacklistedSlot);
                if (plan.canStack(slot, blacklistedItem)) continue block4;
            }
            return slot;
        }
        return -1;
    }

    protected final List<ItemStackResponseContainer> makeContainerEntries(GeyserSession session, Type inventory, IntSet affectedSlots) {
        HashMap<ContainerSlotType, List> containerMap = new HashMap<ContainerSlotType, List>();
        IntIterator it = affectedSlots.iterator();
        while (it.hasNext()) {
            int slot = it.nextInt();
            BedrockContainerSlot bedrockSlot = this.javaSlotToBedrockContainer(slot, inventory);
            List list = containerMap.computeIfAbsent(bedrockSlot.container(), k -> new ArrayList());
            list.add(InventoryTranslator.makeItemEntry(bedrockSlot.slot(), ((Inventory)inventory).getItem(slot)));
        }
        ArrayList<ItemStackResponseContainer> containerEntries = new ArrayList<ItemStackResponseContainer>();
        for (Map.Entry entry : containerMap.entrySet()) {
            containerEntries.add(new ItemStackResponseContainer((ContainerSlotType)((Object)entry.getKey()), (List)entry.getValue(), new FullContainerName((ContainerSlotType)((Object)entry.getKey()), null)));
        }
        ItemStackResponseSlot cursorEntry = InventoryTranslator.makeItemEntry(0, session.getPlayerInventory().getCursor());
        containerEntries.add(new ItemStackResponseContainer(ContainerSlotType.CURSOR, Collections.singletonList(cursorEntry), new FullContainerName(ContainerSlotType.CURSOR, null)));
        return containerEntries;
    }

    private static ItemStackResponseSlot makeItemEntry(int bedrockSlot, GeyserItemStack itemStack) {
        ItemStackResponseSlot itemEntry;
        if (!itemStack.isEmpty()) {
            int durability = 0;
            Integer damage = itemStack.getComponent(DataComponentTypes.DAMAGE);
            if (damage != null) {
                durability = ItemUtils.getCorrectBedrockDurability(itemStack.asItem(), damage);
            }
            itemEntry = new ItemStackResponseSlot((byte)bedrockSlot, (byte)bedrockSlot, (byte)itemStack.getAmount(), itemStack.getNetId(), "", durability, "");
        } else {
            itemEntry = new ItemStackResponseSlot((byte)bedrockSlot, (byte)bedrockSlot, 0, 0, "", 0, "");
        }
        return itemEntry;
    }

    protected static boolean isCursor(ItemStackRequestSlotData slotInfoData) {
        return slotInfoData.getContainerName().getContainer() == ContainerSlotType.CURSOR;
    }

    public static @Nullable InventoryTranslator<? extends Inventory> inventoryTranslator(@Nullable ContainerType type) {
        if (type == null) {
            return PLAYER_INVENTORY_TRANSLATOR;
        }
        return INVENTORY_TRANSLATORS.get((Object)type);
    }

    public InventoryTranslator(int size) {
        this.size = size;
    }

    protected static enum CraftState {
        START,
        RECIPE_ID,
        DEPRECATED,
        INGREDIENTS,
        TRANSFER,
        DONE;

    }
}

