/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.bedrock;

import org.cloudburstmc.math.vector.Vector3i;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.structure.StructureSettings;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.structure.StructureTemplateRequestOperation;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.StructureTemplateDataRequestPacket;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.StructureBlockUtils;
import org.geysermc.mcprotocollib.protocol.data.game.inventory.UpdateStructureBlockAction;
import org.geysermc.mcprotocollib.protocol.data.game.inventory.UpdateStructureBlockMode;

@Translator(packet=StructureTemplateDataRequestPacket.class)
public class BedrockStructureTemplateDataRequestTranslator
extends PacketTranslator<StructureTemplateDataRequestPacket> {
    @Override
    public void translate(GeyserSession session, StructureTemplateDataRequestPacket packet) {
        if (packet.getOperation().equals((Object)StructureTemplateRequestOperation.QUERY_SAVED_STRUCTURE)) {
            Vector3i size = packet.getSettings().getSize();
            StructureSettings settings = packet.getSettings();
            String currentStructureName = session.getStructureBlockCache().getCurrentStructureName();
            if (!packet.getSettings().getSize().equals(Vector3i.ZERO)) {
                if (currentStructureName == null) {
                    Vector3i offset = StructureBlockUtils.calculateOffset(settings.getRotation(), settings.getMirror(), settings.getSize().getX(), settings.getSize().getZ());
                    session.getStructureBlockCache().setBedrockOffset(offset);
                    session.getStructureBlockCache().setCurrentStructureName(packet.getName());
                    StructureBlockUtils.sendStructureData(session, size, packet.getName());
                    return;
                }
                if (packet.getName().equals(currentStructureName)) {
                    StructureBlockUtils.sendStructureData(session, size, packet.getName());
                    return;
                }
            }
            session.getStructureBlockCache().setCurrentStructureBlock(packet.getPosition());
            StructureBlockUtils.sendJavaStructurePacket(session, packet.getPosition(), Vector3i.ZERO, UpdateStructureBlockMode.LOAD, UpdateStructureBlockAction.LOAD_STRUCTURE, settings, true, packet.getName());
        } else {
            StructureBlockUtils.sendEmptyStructureData(session);
        }
    }
}

