/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.item.component;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DyedItemColor {
    private final int rgb;
    private final boolean showInTooltip;

    public static @NonNull DyedItemColorBuilder builder() {
        return new DyedItemColorBuilder();
    }

    public @NonNull DyedItemColorBuilder toBuilder() {
        return new DyedItemColorBuilder().rgb(this.rgb).showInTooltip(this.showInTooltip);
    }

    public int getRgb() {
        return this.rgb;
    }

    public boolean isShowInTooltip() {
        return this.showInTooltip;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DyedItemColor)) {
            return false;
        }
        DyedItemColor other = (DyedItemColor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRgb() != other.getRgb()) {
            return false;
        }
        return this.isShowInTooltip() == other.isShowInTooltip();
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof DyedItemColor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRgb();
        result = result * 59 + (this.isShowInTooltip() ? 79 : 97);
        return result;
    }

    public @NonNull String toString() {
        return "DyedItemColor(rgb=" + this.getRgb() + ", showInTooltip=" + this.isShowInTooltip() + ")";
    }

    public DyedItemColor(int rgb, boolean showInTooltip) {
        this.rgb = rgb;
        this.showInTooltip = showInTooltip;
    }

    public static class DyedItemColorBuilder {
        private int rgb;
        private boolean showInTooltip;

        DyedItemColorBuilder() {
        }

        public @NonNull DyedItemColorBuilder rgb(int rgb) {
            this.rgb = rgb;
            return this;
        }

        public @NonNull DyedItemColorBuilder showInTooltip(boolean showInTooltip) {
            this.showInTooltip = showInTooltip;
            return this;
        }

        public @NonNull DyedItemColor build() {
            return new DyedItemColor(this.rgb, this.showInTooltip);
        }

        public @NonNull String toString() {
            return "DyedItemColor.DyedItemColorBuilder(rgb=" + this.rgb + ", showInTooltip=" + this.showInTooltip + ")";
        }
    }
}

