/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.spigot;

import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.data.MappingData;
import com.viaversion.viaversion.api.protocol.ProtocolPathEntry;
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.GeyserBootstrap;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.adapters.paper.PaperAdapters;
import org.geysermc.geyser.adapters.spigot.SpigotAdapters;
import org.geysermc.geyser.api.util.PlatformType;
import org.geysermc.geyser.api.util.TriState;
import org.geysermc.geyser.command.CommandRegistry;
import org.geysermc.geyser.command.CommandSourceConverter;
import org.geysermc.geyser.command.GeyserCommandSource;
import org.geysermc.geyser.configuration.GeyserConfiguration;
import org.geysermc.geyser.dump.BootstrapDumpInfo;
import org.geysermc.geyser.level.WorldManager;
import org.geysermc.geyser.network.GameProtocol;
import org.geysermc.geyser.ping.GeyserLegacyPingPassthrough;
import org.geysermc.geyser.ping.IGeyserPingPassthrough;
import org.geysermc.geyser.platform.spigot.GeyserPaperLogger;
import org.geysermc.geyser.platform.spigot.GeyserPaperPingPassthrough;
import org.geysermc.geyser.platform.spigot.GeyserSpigotConfiguration;
import org.geysermc.geyser.platform.spigot.GeyserSpigotDumpInfo;
import org.geysermc.geyser.platform.spigot.GeyserSpigotInjector;
import org.geysermc.geyser.platform.spigot.GeyserSpigotLogger;
import org.geysermc.geyser.platform.spigot.GeyserSpigotPingPassthrough;
import org.geysermc.geyser.platform.spigot.GeyserSpigotUpdateListener;
import org.geysermc.geyser.platform.spigot.GeyserSpigotVersionChecker;
import org.geysermc.geyser.platform.spigot.PaperAdventure;
import org.geysermc.geyser.platform.spigot.ReflectedNames;
import org.geysermc.geyser.platform.spigot.command.SpigotCommandRegistry;
import org.geysermc.geyser.platform.spigot.command.SpigotCommandSource;
import org.geysermc.geyser.platform.spigot.shaded.org.incendo.cloud.bukkit.BukkitCommandManager;
import org.geysermc.geyser.platform.spigot.shaded.org.incendo.cloud.execution.ExecutionCoordinator;
import org.geysermc.geyser.platform.spigot.shaded.org.incendo.cloud.paper.LegacyPaperCommandManager;
import org.geysermc.geyser.platform.spigot.world.GeyserPistonListener;
import org.geysermc.geyser.platform.spigot.world.GeyserSpigotBlockPlaceListener;
import org.geysermc.geyser.platform.spigot.world.manager.GeyserSpigotLegacyNativeWorldManager;
import org.geysermc.geyser.platform.spigot.world.manager.GeyserSpigotNativeWorldManager;
import org.geysermc.geyser.platform.spigot.world.manager.GeyserSpigotWorldManager;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.util.FileUtils;

public class GeyserSpigotPlugin
extends JavaPlugin
implements GeyserBootstrap {
    private CommandRegistry commandRegistry;
    private GeyserSpigotConfiguration geyserConfig;
    private GeyserSpigotInjector geyserInjector;
    private final GeyserSpigotLogger geyserLogger = GeyserPaperLogger.supported() ? new GeyserPaperLogger((Plugin)this, this.getLogger()) : new GeyserSpigotLogger(this.getLogger());
    private IGeyserPingPassthrough geyserSpigotPingPassthrough;
    private GeyserSpigotWorldManager geyserWorldManager;
    private GeyserImpl geyser;
    private String minecraftVersion;

    public void onLoad() {
        this.onGeyserInitialize();
    }

    @Override
    public void onGeyserInitialize() {
        block11: {
            GeyserLocale.init(this);
            try {
                ByteBuf.class.getMethod("writeShortLE", Integer.TYPE);
                Class.forName("org.bukkit.event.server.ServerLoadEvent");
                BlockData.class.getMethod("getAsString", new Class[0]);
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                this.geyserLogger.error("*********************************************");
                this.geyserLogger.error("");
                this.geyserLogger.error(GeyserLocale.getLocaleStringLog("geyser.bootstrap.unsupported_server.header"));
                this.geyserLogger.error(GeyserLocale.getLocaleStringLog("geyser.bootstrap.unsupported_server.message", "1.13.2"));
                this.geyserLogger.error("");
                this.geyserLogger.error("*********************************************");
                return;
            }
            try {
                Class.forName("net.md_5.bungee.chat.ComponentSerializer");
            }
            catch (ClassNotFoundException e) {
                if (PaperAdventure.canSendMessageUsingComponent()) break block11;
                this.geyserLogger.error("*********************************************");
                this.geyserLogger.error("");
                this.geyserLogger.error(GeyserLocale.getLocaleStringLog("geyser.bootstrap.unsupported_server_type.header", this.getServer().getName()));
                this.geyserLogger.error(GeyserLocale.getLocaleStringLog("geyser.bootstrap.unsupported_server_type.message", "Paper"));
                this.geyserLogger.error("");
                this.geyserLogger.error("*********************************************");
                return;
            }
        }
        try {
            Class.forName("io.netty.util.internal.ObjectPool$ObjectCreator");
        }
        catch (ClassNotFoundException e) {
            this.geyserLogger.error("*********************************************");
            this.geyserLogger.error("");
            this.geyserLogger.error("This version of Spigot is using an outdated version of netty. Please use Paper instead!");
            this.geyserLogger.error("");
            this.geyserLogger.error("*********************************************");
            return;
        }
        try {
            if (Bukkit.getServer().spigot().getConfig().getBoolean("settings.bungeecord")) {
                this.warnInvalidProxySetups("BungeeCord");
                return;
            }
            if (Bukkit.getServer().spigot().getPaperConfig().getBoolean("proxies.velocity.enabled")) {
                this.warnInvalidProxySetups("Velocity");
                return;
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        if (!this.loadConfig()) {
            return;
        }
        this.geyserLogger.setDebug(this.geyserConfig.isDebugMode());
        GeyserConfiguration.checkGeyserConfiguration(this.geyserConfig, this.geyserLogger);
        this.minecraftVersion = Bukkit.getServer().getVersion().split("\\(MC: ")[1].split("\\)")[0];
        this.geyser = GeyserImpl.load(PlatformType.SPIGOT, this);
    }

    public void onEnable() {
        LegacyPaperCommandManager<GeyserCommandSource> cloud;
        if (this.geyser == null) {
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        CommandSourceConverter<CommandSender> sourceConverter = new CommandSourceConverter<CommandSender>(CommandSender.class, Bukkit::getPlayer, Bukkit::getConsoleSender, SpigotCommandSource::new);
        try {
            cloud = new LegacyPaperCommandManager<GeyserCommandSource>((Plugin)this, ExecutionCoordinator.simpleCoordinator(), sourceConverter);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            cloud.registerBrigadier();
        }
        catch (BukkitCommandManager.BrigadierInitializationException e) {
            this.geyserLogger.debug("Failed to initialize Brigadier support: " + e.getMessage());
        }
        this.commandRegistry = new SpigotCommandRegistry(this.geyser, cloud);
        Bukkit.getPluginManager().registerEvents(new Listener(){

            @EventHandler
            public void onServerLoaded(ServerLoadEvent event) {
                if (event.getType() == ServerLoadEvent.LoadType.RELOAD) {
                    GeyserSpigotPlugin.this.geyser.setShuttingDown(false);
                }
                GeyserSpigotPlugin.this.onGeyserEnable();
            }
        }, (Plugin)this);
    }

    @Override
    public void onGeyserEnable() {
        block10: {
            if (GeyserImpl.getInstance().isReloading()) {
                if (!this.loadConfig()) {
                    return;
                }
                this.geyserLogger.setDebug(this.geyserConfig.isDebugMode());
                GeyserConfiguration.checkGeyserConfiguration(this.geyserConfig, this.geyserLogger);
            }
            GeyserImpl.start();
            this.geyserSpigotPingPassthrough = this.geyserConfig.isLegacyPingPassthrough() ? GeyserLegacyPingPassthrough.init(this.geyser) : (ReflectedNames.checkPaperPingEvent() ? new GeyserPaperPingPassthrough(this.geyserLogger) : (ReflectedNames.newSpigotPingConstructorExists() ? new GeyserSpigotPingPassthrough(this.geyserLogger) : GeyserLegacyPingPassthrough.init(this.geyser)));
            this.geyserLogger.debug("Spigot ping passthrough type: " + String.valueOf(this.geyserSpigotPingPassthrough == null ? null : this.geyserSpigotPingPassthrough.getClass()));
            if (GeyserImpl.getInstance().isReloading()) {
                return;
            }
            boolean isViaVersion = Bukkit.getPluginManager().getPlugin("ViaVersion") != null;
            GeyserSpigotVersionChecker.checkForSupportedProtocol(this.geyserLogger, isViaVersion);
            this.geyserInjector = new GeyserSpigotInjector(isViaVersion);
            this.geyserInjector.initializeLocalChannel(this);
            if (Boolean.parseBoolean(System.getProperty("Geyser.UseDirectAdapters", "true"))) {
                try {
                    boolean isPaper = false;
                    try {
                        String name = Bukkit.getServer().getClass().getPackage().getName();
                        String nmsVersion = name.substring(name.lastIndexOf(46) + 1);
                        SpigotAdapters.registerWorldAdapter(nmsVersion);
                        this.geyserLogger.debug("Using spigot NMS adapter for nms version: " + nmsVersion);
                    }
                    catch (Exception e) {
                        this.geyserLogger.debug("Unable to find spigot world manager: " + e.getMessage());
                        int protocolVersion = Bukkit.getUnsafe().getProtocolVersion();
                        PaperAdapters.registerClosestWorldAdapter(protocolVersion);
                        isPaper = true;
                        this.geyserLogger.debug("Using paper world adapter for protocol version: " + protocolVersion);
                    }
                    this.geyserWorldManager = isViaVersion && this.isViaVersionNeeded() ? new GeyserSpigotLegacyNativeWorldManager(this, isPaper) : new GeyserSpigotNativeWorldManager((Plugin)this, isPaper);
                    this.geyserLogger.debug("Using world manager of type: " + this.geyserWorldManager.getClass().getSimpleName());
                }
                catch (Throwable e) {
                    if (this.geyserConfig.isDebugMode()) {
                        this.geyserLogger.debug("Error while attempting to find NMS adapter. Most likely, this can be safely ignored. :)");
                        e.printStackTrace();
                    }
                    break block10;
                }
            }
            this.geyserLogger.debug("Not using NMS adapter as it is disabled via system property.");
        }
        if (this.geyserWorldManager == null) {
            this.geyserWorldManager = new GeyserSpigotWorldManager((Plugin)this);
            this.geyserLogger.debug("Using default world manager.");
        }
        PluginManager pluginManager = Bukkit.getPluginManager();
        this.geyser.eventBus().fire((permission, def) -> {
            Objects.requireNonNull(permission, "permission");
            Objects.requireNonNull(def, "permission default for " + permission);
            if (permission.isBlank()) {
                return;
            }
            PermissionDefault permissionDefault = switch (def) {
                default -> throw new IncompatibleClassChangeError();
                case TriState.TRUE -> PermissionDefault.TRUE;
                case TriState.FALSE -> PermissionDefault.FALSE;
                case TriState.NOT_SET -> PermissionDefault.OP;
            };
            Permission existingPermission = pluginManager.getPermission(permission);
            if (existingPermission != null) {
                this.geyserLogger.debug("permission " + permission + " with default " + String.valueOf(existingPermission.getDefault()) + " is being overridden by " + String.valueOf(permissionDefault));
                pluginManager.removePermission(permission);
            }
            pluginManager.addPermission(new Permission(permission, permissionDefault));
        });
        GeyserSpigotBlockPlaceListener blockPlaceListener = new GeyserSpigotBlockPlaceListener(this.geyser, this.geyserWorldManager);
        pluginManager.registerEvents((Listener)blockPlaceListener, (Plugin)this);
        pluginManager.registerEvents((Listener)new GeyserPistonListener(this.geyser, this.geyserWorldManager), (Plugin)this);
        pluginManager.registerEvents((Listener)new GeyserSpigotUpdateListener(), (Plugin)this);
    }

    @Override
    public void onGeyserDisable() {
        if (this.geyser != null) {
            this.geyser.disable();
        }
    }

    @Override
    public void onGeyserShutdown() {
        if (this.geyser != null) {
            this.geyser.shutdown();
        }
        if (this.geyserInjector != null) {
            this.geyserInjector.shutdown();
        }
    }

    public void onDisable() {
        this.onGeyserShutdown();
    }

    @Override
    public GeyserSpigotConfiguration getGeyserConfig() {
        return this.geyserConfig;
    }

    @Override
    public GeyserSpigotLogger getGeyserLogger() {
        return this.geyserLogger;
    }

    @Override
    public CommandRegistry getCommandRegistry() {
        return this.commandRegistry;
    }

    @Override
    public IGeyserPingPassthrough getGeyserPingPassthrough() {
        return this.geyserSpigotPingPassthrough;
    }

    @Override
    public WorldManager getWorldManager() {
        return this.geyserWorldManager;
    }

    @Override
    public Path getConfigFolder() {
        return this.getDataFolder().toPath();
    }

    @Override
    public BootstrapDumpInfo getDumpInfo() {
        return new GeyserSpigotDumpInfo();
    }

    @Override
    public String getMinecraftServerVersion() {
        return this.minecraftVersion;
    }

    @Override
    public SocketAddress getSocketAddress() {
        return this.geyserInjector.getServerSocketAddress();
    }

    public ProtocolVersion getServerProtocolVersion() {
        return ProtocolVersion.getClosest((String)this.minecraftVersion);
    }

    private boolean isViaVersionNeeded() {
        ProtocolVersion serverVersion = this.getServerProtocolVersion();
        List protocolList = Via.getManager().getProtocolManager().getProtocolPath(GameProtocol.getJavaProtocolVersion(), serverVersion.getVersion());
        if (protocolList == null) {
            return false;
        }
        for (int i = protocolList.size() - 1; i >= 0; --i) {
            MappingData mappingData = ((ProtocolPathEntry)protocolList.get(i)).protocol().getMappingData();
            if (mappingData == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public @NonNull String getServerBindAddress() {
        return Bukkit.getIp();
    }

    @Override
    public int getServerPort() {
        return Bukkit.getPort();
    }

    @Override
    public boolean testFloodgatePluginPresent() {
        if (Bukkit.getPluginManager().getPlugin("floodgate") != null) {
            this.geyserConfig.loadFloodgate(this);
            return true;
        }
        return false;
    }

    private boolean loadConfig() {
        try {
            if (!this.getDataFolder().exists()) {
                this.getDataFolder().mkdir();
            }
            File configFile = FileUtils.fileOrCopiedFromResource(new File(this.getDataFolder(), "config.yml"), "config.yml", x -> x.replaceAll("generateduuid", UUID.randomUUID().toString()), this);
            this.geyserConfig = FileUtils.loadConfig(configFile, GeyserSpigotConfiguration.class);
        }
        catch (IOException ex) {
            this.geyserLogger.error(GeyserLocale.getLocaleStringLog("geyser.config.failed"), ex);
            ex.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return false;
        }
        return true;
    }

    private void warnInvalidProxySetups(String platform) {
        this.geyserLogger.error("*********************************************");
        this.geyserLogger.error("");
        this.geyserLogger.error(GeyserLocale.getLocaleStringLog("geyser.bootstrap.unsupported_proxy_backend", platform));
        this.geyserLogger.error(GeyserLocale.getLocaleStringLog("geyser.bootstrap.setup_guide", "https://geysermc.org/wiki/geyser/setup/"));
        this.geyserLogger.error("");
        this.geyserLogger.error("*********************************************");
    }
}

