/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.dialog.input;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.nbt.NbtType;
import org.geysermc.cumulus.form.CustomForm;
import org.geysermc.cumulus.response.CustomFormResponse;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.key.Key;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.dialog.input.DialogInput;
import org.geysermc.geyser.session.dialog.input.DialogInputParseException;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.geyser.util.MinecraftKey;

public class SingleOptionInput
extends DialogInput<String> {
    public static final Key TYPE = MinecraftKey.key("single_option");
    private final boolean labelVisible;
    private final List<Entry> entries = new ArrayList<Entry>();
    private final int initial;

    public SingleOptionInput(Optional<GeyserSession> session, NbtMap map) {
        super(session, map);
        this.labelVisible = map.getBoolean("label_visible", true);
        List<NbtMap> entriesTag = map.getList("options", NbtType.COMPOUND);
        int temp = 0;
        for (int i = 0; i < entriesTag.size(); ++i) {
            NbtMap entry = entriesTag.get(i);
            this.entries.add(new Entry(entry.getString("id"), Optional.ofNullable(MessageTranslator.convertFromNullableNbtTag(session, entry.get("display")))));
            if (!entry.getBoolean("initial")) continue;
            temp = i;
        }
        this.initial = temp;
    }

    @Override
    public void addComponent(CustomForm.Builder builder, Optional<String> restored) {
        int defaultOption = this.initial;
        if (restored.isPresent()) {
            for (int i = 0; i < this.entries.size(); ++i) {
                if (!this.entries.get(i).id().equals(restored.get())) continue;
                defaultOption = i;
                break;
            }
        }
        builder.dropdown(this.labelVisible ? this.label : "", this.entries.stream().map(Entry::label).toList(), defaultOption);
    }

    @Override
    public String read(CustomFormResponse response) throws DialogInputParseException {
        return this.entries.get(response.asDropdown()).id();
    }

    @Override
    public String asSubstitution(String value) {
        return value;
    }

    @Override
    public void addToMap(NbtMapBuilder builder, String value) {
        builder.putString(this.key, value);
    }

    @Override
    public String defaultValue() {
        return this.entries.get(this.initial).id();
    }

    private record Entry(String id, Optional<String> fancyLabel) {
        public String label() {
            return this.fancyLabel.orElse(this.id);
        }
    }
}

