/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.msa.request;

import java.net.MalformedURLException;
import java.util.HashMap;
import net.lenni0451.commons.gson.elements.GsonObject;
import net.lenni0451.commons.httpclient.HttpResponse;
import net.lenni0451.commons.httpclient.content.impl.URLEncodedFormContent;
import net.lenni0451.commons.httpclient.requests.impl.PostRequest;
import net.raphimc.minecraftauth.msa.model.MsaApplicationConfig;
import net.raphimc.minecraftauth.msa.model.MsaToken;
import net.raphimc.minecraftauth.msa.responsehandler.MsaResponseHandler;

public class MsaAuthCodeTokenRequest
extends PostRequest
implements MsaResponseHandler<MsaToken> {
    public MsaAuthCodeTokenRequest(MsaApplicationConfig applicationConfig, String authCode) throws MalformedURLException {
        super(applicationConfig.getEnvironment().getTokenUrl());
        HashMap<String, String> postData = new HashMap<String, String>();
        postData.put("client_id", applicationConfig.getClientId());
        postData.put("scope", applicationConfig.getScope());
        if (applicationConfig.getClientSecret() != null) {
            postData.put("client_secret", applicationConfig.getClientSecret());
        }
        if (applicationConfig.getRedirectUri() != null) {
            postData.put("redirect_uri", applicationConfig.getRedirectUri());
        }
        postData.put("grant_type", "authorization_code");
        postData.put("code", authCode);
        this.setContent(new URLEncodedFormContent(postData));
    }

    @Override
    public MsaToken handle(HttpResponse response, GsonObject json) {
        return new MsaToken(System.currentTimeMillis() + (long)json.reqInt("expires_in") * 1000L, json.reqString("access_token"), json.getString("refresh_token", null));
    }
}

