/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.erosion.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import io.netty.handler.codec.CorruptedFrameException;
import java.util.List;
import org.cloudburstmc.protocol.common.util.VarInts;

public final class VarIntLengthManager
extends ByteToMessageCodec<ByteBuf> {
    private int getLengthSize(int length) {
        if ((length & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((length & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((length & 0xFFE00000) == 0) {
            return 3;
        }
        if ((length & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    @Override
    public void encode(ChannelHandlerContext ctx, ByteBuf in, ByteBuf out) {
        int length = in.readableBytes();
        out.ensureWritable(this.getLengthSize(length) + length);
        VarInts.writeUnsignedInt(out, length);
        out.writeBytes(in);
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) {
        buf.markReaderIndex();
        byte[] lengthBytes = new byte[5];
        for (int index = 0; index < lengthBytes.length; ++index) {
            if (!buf.isReadable()) {
                buf.resetReaderIndex();
                return;
            }
            lengthBytes[index] = buf.readByte();
            if (lengthBytes[index] < 0) continue;
            int length = VarInts.readUnsignedInt(Unpooled.wrappedBuffer((byte[])lengthBytes));
            if (buf.readableBytes() < length) {
                buf.resetReaderIndex();
                return;
            }
            out.add(buf.readBytes(length));
            return;
        }
        throw new CorruptedFrameException("Length is too long.");
    }
}

