/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.crypto;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.geysermc.floodgate.crypto.KeyProducer;

public final class AesKeyProducer
implements KeyProducer {
    public static final int KEY_SIZE = 128;

    @Override
    public SecretKey produce() {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(128, this.secureRandom());
            return keyGenerator.generateKey();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public SecretKey produceFrom(byte[] keyFileData) {
        try {
            return new SecretKeySpec(keyFileData, "AES");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private SecureRandom secureRandom() throws NoSuchAlgorithmException {
        try {
            if (System.getProperty("os.name").startsWith("Windows")) {
                return SecureRandom.getInstance("Windows-PRNG");
            }
            return SecureRandom.getInstance("NativePRNGNonBlocking");
        }
        catch (NoSuchAlgorithmException ignored) {
            return new SecureRandom();
        }
    }
}

