/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.animal;

import java.util.List;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.TrigMath;
import org.cloudburstmc.math.vector.Vector2f;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.AttributeData;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.living.animal.AnimalEntity;
import org.geysermc.geyser.entity.type.player.SessionPlayerEntity;
import org.geysermc.geyser.entity.vehicle.ClientVehicle;
import org.geysermc.geyser.entity.vehicle.HappyGhastVehicleComponent;
import org.geysermc.geyser.entity.vehicle.VehicleComponent;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.tags.ItemTag;
import org.geysermc.geyser.session.cache.tags.Tag;
import org.geysermc.geyser.util.AttributeUtils;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.geyser.util.InteractiveTag;
import org.geysermc.mcprotocollib.protocol.data.game.entity.EquipmentSlot;
import org.geysermc.mcprotocollib.protocol.data.game.entity.attribute.Attribute;
import org.geysermc.mcprotocollib.protocol.data.game.entity.attribute.AttributeType;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.BooleanEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;

public class HappyGhastEntity
extends AnimalEntity
implements ClientVehicle {
    public static final float[] X_OFFSETS = new float[]{0.0f, -1.7f, 0.0f, 1.7f};
    public static final float[] Z_OFFSETS = new float[]{1.7f, 0.0f, -1.7f, 0.0f};
    private final HappyGhastVehicleComponent vehicleComponent = new HappyGhastVehicleComponent(this, 0.0f);
    private boolean staysStill;

    public HappyGhastEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    @Override
    protected void initializeMetadata() {
        super.initializeMetadata();
        this.setFlag(EntityFlag.CAN_FLY, true);
        this.setFlag(EntityFlag.CAN_WALK, true);
        this.setFlag(EntityFlag.TAMED, true);
        this.setFlag(EntityFlag.BODY_ROTATION_ALWAYS_FOLLOWS_HEAD, true);
        this.setFlag(EntityFlag.COLLIDABLE, true);
        this.setFlag(EntityFlag.WASD_AIR_CONTROLLED, true);
        this.setFlag(EntityFlag.DOES_SERVER_AUTH_ONLY_DISMOUNT, true);
        this.propertyManager.add("minecraft:can_move", true);
    }

    @Override
    protected @Nullable Tag<Item> getFoodTag() {
        return ItemTag.HAPPY_GHAST_FOOD;
    }

    @Override
    protected float getBabySize() {
        return 0.2375f;
    }

    @Override
    protected float getAdultSize() {
        return 1.001f;
    }

    @Override
    public void setBaby(BooleanEntityMetadata entityMetadata) {
        super.setBaby(entityMetadata);
        this.setFlag(EntityFlag.COLLIDABLE, !entityMetadata.getPrimitiveValue());
    }

    public void setStaysStill(BooleanEntityMetadata entityMetadata) {
        this.staysStill = entityMetadata.getPrimitiveValue();
        this.propertyManager.add("minecraft:can_move", !entityMetadata.getPrimitiveValue());
        this.updateBedrockEntityProperties();
    }

    @Override
    protected @NonNull InteractiveTag testMobInteraction(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        if (this.isBaby()) {
            return super.testMobInteraction(hand, itemInHand);
        }
        if (!itemInHand.isEmpty() && this.session.getTagCache().is(ItemTag.HARNESSES, itemInHand) && this.equipment.get((Object)EquipmentSlot.BODY) == null) {
            return InteractiveTag.EQUIP_HARNESS;
        }
        if (this.equipment.get((Object)EquipmentSlot.BODY) != null && !this.session.isSneaking()) {
            return InteractiveTag.RIDE_HORSE;
        }
        return super.testMobInteraction(hand, itemInHand);
    }

    @Override
    protected @NonNull InteractionResult mobInteract(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        if (this.isBaby()) {
            return super.mobInteract(hand, itemInHand);
        }
        if (!itemInHand.isEmpty() && this.session.getTagCache().is(ItemTag.HARNESSES, itemInHand) && this.equipment.get((Object)EquipmentSlot.BODY) == null) {
            return InteractionResult.SUCCESS;
        }
        if (this.equipment.get((Object)EquipmentSlot.BODY) == null && !this.session.isSneaking()) {
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(hand, itemInHand);
    }

    @Override
    public VehicleComponent<?> getVehicleComponent() {
        return this.vehicleComponent;
    }

    @Override
    public Vector3f getRiddenInput(Vector2f input) {
        float x = input.getX();
        float y = 0.0f;
        float z = 0.0f;
        if (input.getY() != 0.0f) {
            float pitch = this.session.getPlayerEntity().getPitch();
            z = TrigMath.cos((double)pitch * (Math.PI / 180));
            y = -TrigMath.sin((double)pitch * (Math.PI / 180));
            if (input.getY() < 0.0f) {
                z *= -0.5f;
                y *= -0.5f;
            }
        }
        if (this.session.getInputCache().wasJumping()) {
            y += 0.5f;
        }
        return Vector3f.from(x, y, z).mul(3.9f * this.vehicleComponent.getFlyingSpeed());
    }

    @Override
    public float getVehicleSpeed() {
        return 0.0f;
    }

    @Override
    public boolean isClientControlled() {
        if (!this.hasBodyArmor() || this.getFlag(EntityFlag.NO_AI) || this.staysStill) {
            return false;
        }
        return this.getFirstPassenger() instanceof SessionPlayerEntity;
    }

    private Entity getFirstPassenger() {
        return this.passengers.isEmpty() ? null : (Entity)this.passengers.get(0);
    }

    @Override
    protected void updateAttribute(Attribute javaAttribute, List<AttributeData> newAttributes) {
        AttributeType.Builtin type;
        super.updateAttribute(javaAttribute, newAttributes);
        AttributeType attributeType = javaAttribute.getType();
        if (attributeType instanceof AttributeType.Builtin && (type = (AttributeType.Builtin)attributeType) == AttributeType.Builtin.CAMERA_DISTANCE) {
            this.vehicleComponent.setCameraDistance((float)AttributeUtils.calculateValue(javaAttribute));
        }
    }

    @Override
    protected boolean canUseSlot(EquipmentSlot slot) {
        return slot != EquipmentSlot.BODY ? super.canUseSlot(slot) : this.isAlive() && !this.isBaby();
    }
}

