/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.codec;

import java.util.EnumMap;
import org.geysermc.mcprotocollib.network.packet.PacketRegistry;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacketRegistry;
import org.geysermc.mcprotocollib.protocol.data.ProtocolState;

public class PacketCodec {
    private final int protocolVersion;
    private final String minecraftVersion;
    private final EnumMap<ProtocolState, PacketRegistry> stateProtocols;

    public PacketRegistry getCodec(ProtocolState protocolState) {
        return this.stateProtocols.get((Object)protocolState);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.protocolVersion = this.protocolVersion;
        builder.stateProtocols = this.stateProtocols;
        builder.minecraftVersion = this.minecraftVersion;
        return builder;
    }

    private PacketCodec(int protocolVersion, String minecraftVersion, EnumMap<ProtocolState, PacketRegistry> stateProtocols) {
        this.protocolVersion = protocolVersion;
        this.minecraftVersion = minecraftVersion;
        this.stateProtocols = stateProtocols;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public String getMinecraftVersion() {
        return this.minecraftVersion;
    }

    public static class Builder {
        private int protocolVersion = -1;
        private String minecraftVersion = null;
        private EnumMap<ProtocolState, PacketRegistry> stateProtocols = new EnumMap(ProtocolState.class);

        public Builder protocolVersion(int protocolVersion) {
            this.protocolVersion = protocolVersion;
            return this;
        }

        public Builder minecraftVersion(String minecraftVersion) {
            this.minecraftVersion = minecraftVersion;
            return this;
        }

        public Builder state(ProtocolState state, MinecraftPacketRegistry protocol) {
            this.stateProtocols.put(state, protocol.build());
            return this;
        }

        public PacketCodec build() {
            return new PacketCodec(this.protocolVersion, this.minecraftVersion, this.stateProtocols);
        }
    }
}

