/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.command;

import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.api.command.Command;
import org.geysermc.geyser.api.util.TriState;
import org.geysermc.geyser.command.GeyserCommandSource;
import org.geysermc.geyser.command.GeyserPermission;
import org.geysermc.geyser.text.GeyserLocale;
import org.incendo.cloud.Command;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.description.CommandDescription;
import org.incendo.cloud.permission.PredicatePermission;
import org.jetbrains.annotations.Contract;

public abstract class GeyserCommand
implements Command {
    public static final String DEFAULT_ROOT_COMMAND = "geyser";
    private final @NonNull String name;
    private final @NonNull String description;
    private final @NonNull String permission;
    private final @Nullable TriState permissionDefault;
    private final boolean playerOnly;
    private final boolean bedrockOnly;
    protected List<String> aliases = Collections.emptyList();

    public GeyserCommand(@NonNull String name, @NonNull String description, @NonNull String permission, @Nullable TriState permissionDefault, boolean playerOnly, boolean bedrockOnly) {
        if (name.isBlank()) {
            throw new IllegalArgumentException("Command cannot be null or blank!");
        }
        if (permission.isBlank()) {
            permission = "";
            permissionDefault = null;
        }
        this.name = name;
        this.description = description;
        this.permission = permission;
        this.permissionDefault = permissionDefault;
        if (bedrockOnly && !playerOnly) {
            throw new IllegalArgumentException("Command cannot be bedrockOnly if it is not playerOnly");
        }
        this.playerOnly = playerOnly;
        this.bedrockOnly = bedrockOnly;
    }

    public GeyserCommand(@NonNull String name, @NonNull String description, @NonNull String permission, @Nullable TriState permissionDefault) {
        this(name, description, permission, permissionDefault, false, false);
    }

    @Override
    public final @NonNull String name() {
        return this.name;
    }

    @Override
    public final @NonNull String description() {
        return this.description;
    }

    @Override
    public final @NonNull String permission() {
        return this.permission;
    }

    public final @Nullable TriState permissionDefault() {
        return this.permissionDefault;
    }

    @Override
    public final boolean isPlayerOnly() {
        return this.playerOnly;
    }

    @Override
    public final boolean isBedrockOnly() {
        return this.bedrockOnly;
    }

    @Override
    public final @NonNull List<String> aliases() {
        return Collections.unmodifiableList(this.aliases);
    }

    public String rootCommand() {
        return DEFAULT_ROOT_COMMAND;
    }

    public final GeyserPermission commandPermission(CommandManager<GeyserCommandSource> manager) {
        return new GeyserPermission(this.bedrockOnly, this.playerOnly, this.permission, manager);
    }

    @Contract(value="_ -> new", pure=true)
    public final Command.Builder<GeyserCommandSource> baseBuilder(CommandManager<GeyserCommandSource> manager) {
        return manager.commandBuilder(this.rootCommand(), new String[0]).literal(this.name, this.aliases.toArray(new String[0])).permission((PredicatePermission)this.commandPermission(manager)).apply(this.meta());
    }

    protected Command.Builder.Applicable<GeyserCommandSource> meta() {
        return builder -> builder.commandDescription(CommandDescription.commandDescription((String)GeyserLocale.getLocaleStringLog(this.description)));
    }

    public void register(CommandManager<GeyserCommandSource> manager) {
        manager.command(this.baseBuilder(manager).handler(this::execute));
    }

    public abstract void execute(CommandContext<GeyserCommandSource> var1);
}

