/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.command.defaults;

import java.util.Comparator;
import java.util.List;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.extension.Extension;
import org.geysermc.geyser.api.util.TriState;
import org.geysermc.geyser.command.GeyserCommand;
import org.geysermc.geyser.command.GeyserCommandSource;
import org.geysermc.geyser.text.GeyserLocale;
import org.incendo.cloud.context.CommandContext;

public class ExtensionsCommand
extends GeyserCommand {
    private final GeyserImpl geyser;

    public ExtensionsCommand(GeyserImpl geyser, String name, String description, String permission) {
        super(name, description, permission, TriState.TRUE);
        this.geyser = geyser;
    }

    @Override
    public void execute(CommandContext<GeyserCommandSource> context) {
        GeyserCommandSource source = (GeyserCommandSource)context.sender();
        int page = 1;
        int maxPage = 1;
        String header = GeyserLocale.getPlayerLocaleString("geyser.commands.extensions.header", source.locale(), page, maxPage);
        source.sendMessage(header);
        this.geyser.extensionManager().extensions().stream().sorted(Comparator.comparing(Extension::name)).forEach(extension -> {
            String extensionName = (extension.isEnabled() ? "\u00a7a" : "\u00a7c") + extension.name();
            source.sendMessage("- " + extensionName + "\u00a7r v" + extension.description().version() + this.formatAuthors(extension.description().authors()));
        });
    }

    private String formatAuthors(List<String> authors) {
        return authors.isEmpty() ? "" : " by: " + String.join((CharSequence)", ", authors);
    }
}

